/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.schema.registries.synchronizers;

import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.schema.registries.synchronizers.AbstractRegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntaxCheckerSynchronizer
extends AbstractRegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(SyntaxCheckerSynchronizer.class);

    public SyntaxCheckerSynchronizer(SchemaManager schemaManager) throws Exception {
        super(schemaManager);
    }

    @Override
    public boolean modify(ModifyOperationContext modifyContext, Entry targetEntry, boolean cascade) throws LdapException {
        Dn name = modifyContext.getDn();
        Entry entry = modifyContext.getEntry();
        String schemaName = this.getSchemaName(name);
        String oid = this.getOid(entry);
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        if (this.isSchemaEnabled(schemaName)) {
            syntaxChecker.setSchemaName(schemaName);
            this.schemaManager.unregisterSyntaxChecker(oid);
            this.schemaManager.add(syntaxChecker);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void add(Entry entry) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "SyntaxChecker");
        this.checkOidIsUniqueForSyntaxChecker(entry);
        String schemaName = this.getSchemaName(dn);
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isEnabled() && syntaxChecker.isEnabled()) {
            if (this.schemaManager.add(syntaxChecker)) {
                LOG.debug("Added {} into the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_386, entry.getDn().getName(), Strings.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("The SyntaxChecker {} cannot be added in the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void delete(Entry entry, boolean cascade) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "SyntaxChecker");
        String schemaName = this.getSchemaName(entry.getDn());
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isDisabled()) {
            LOG.debug("The SyntaxChecker {} cannot be deleted from the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
            return;
        }
        SyntaxChecker syntaxChecker = null;
        try {
            syntaxChecker = this.checkSyntaxCheckerOidExists(entry);
        }
        catch (LdapSchemaViolationException lsve) {
            syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
            if (this.schemaManager.getRegistries().contains(syntaxChecker)) {
                this.schemaManager.getRegistries().dissociateFromSchema(syntaxChecker);
                return;
            }
            String msg = I18n.err(I18n.ERR_387, entry.getDn().getName());
            LOG.info(msg);
            throw new LdapSchemaViolationException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        if (schema.isEnabled() && syntaxChecker.isEnabled()) {
            if (this.schemaManager.delete(syntaxChecker)) {
                LOG.debug("Deleted {} from the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_386, entry.getDn().getName(), Strings.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("The syntaxChecker {} cannot be deleted from the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
    }

    @Override
    public void rename(Entry entry, Rdn newRdn, boolean cascade) throws LdapException {
        String oldOid = this.getOid(entry);
        String schemaName = this.getSchemaName(entry.getDn());
        if (this.schemaManager.getLdapSyntaxRegistry().contains(oldOid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_389, oldOid));
        }
        Entry targetEntry = entry.clone();
        String newOid = newRdn.getNormValue().getString();
        if (this.schemaManager.getSyntaxCheckerRegistry().contains(newOid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_390, newOid));
        }
        targetEntry.put("m-oid", newOid);
        if (this.isSchemaEnabled(schemaName)) {
            SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
            this.schemaManager.unregisterSyntaxChecker(oldOid);
            this.schemaManager.add(syntaxChecker);
        }
    }

    @Override
    public void moveAndRename(Dn oriChildName, Dn newParentName, Rdn newRdn, boolean deleteOldRn, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        if (this.schemaManager.getLdapSyntaxRegistry().contains(oldOid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_391, oldOid));
        }
        Entry targetEntry = entry.clone();
        String newOid = newRdn.getNormValue().getString();
        if (this.schemaManager.getSyntaxCheckerRegistry().contains(newOid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_390, newOid));
        }
        targetEntry.put("m-oid", newOid);
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterSyntaxChecker(oldOid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(syntaxChecker);
        }
    }

    @Override
    public void move(Dn oriChildName, Dn newParentName, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        if (this.schemaManager.getLdapSyntaxRegistry().contains(oid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_393, oid));
        }
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterSyntaxChecker(oid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(syntaxChecker);
        }
    }

    private void checkOidIsUniqueForSyntaxChecker(Entry entry) throws LdapException {
        String oid = this.getOid(entry);
        if (this.schemaManager.getNormalizerRegistry().contains(oid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_390, oid));
        }
    }

    protected SyntaxChecker checkSyntaxCheckerOidExists(Entry entry) throws LdapException {
        String oid = this.getOid(entry);
        if (this.schemaManager.getSyntaxCheckerRegistry().contains(oid)) {
            return (SyntaxChecker)this.schemaManager.getSyntaxCheckerRegistry().get(oid);
        }
        throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_336, oid));
    }

    private void checkNewParent(Dn newParent) throws LdapException {
        if (newParent.size() != 3) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_396, new Object[0]));
        }
        Rdn rdn = newParent.getRdn();
        if (!this.schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_397, new Object[0]));
        }
        if (!rdn.getNormValue().getString().equalsIgnoreCase("syntaxCheckers")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_372, new Object[0]));
        }
    }
}

