/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa.commands;

import net.sf.ehcache.Element;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.SoftLock;
import net.sf.ehcache.transaction.SoftLockFactory;
import net.sf.ehcache.transaction.xa.OptimisticLockFailureException;
import net.sf.ehcache.transaction.xa.XidTransactionID;
import net.sf.ehcache.transaction.xa.commands.Command;

public abstract class AbstractStoreCommand
implements Command {
    private final Element oldElement;
    private final Element newElement;
    private Element softLockedElement;

    public AbstractStoreCommand(Element oldElement, Element newElement) {
        this.newElement = newElement;
        this.oldElement = oldElement;
    }

    protected Element getOldElement() {
        return this.oldElement;
    }

    protected Element getNewElement() {
        return this.newElement;
    }

    public boolean prepare(Store store, SoftLockFactory softLockFactory, XidTransactionID transactionId, ElementValueComparator comparator) {
        Object objectKey = this.getObjectKey();
        SoftLock softLock = softLockFactory.createSoftLock(transactionId, objectKey, this.newElement, this.oldElement);
        this.softLockedElement = this.createElement(objectKey, softLock);
        softLock.lock();
        softLock.freeze();
        if (this.oldElement == null) {
            Element previousElement = store.putIfAbsent(this.softLockedElement);
            if (previousElement != null) {
                softLock.unfreeze();
                softLock.unlock();
                this.softLockedElement = null;
                throw new OptimisticLockFailureException();
            }
        } else {
            boolean replaced = store.replace(this.oldElement, this.softLockedElement, comparator);
            if (!replaced) {
                softLock.unfreeze();
                softLock.unlock();
                this.softLockedElement = null;
                throw new OptimisticLockFailureException();
            }
        }
        return true;
    }

    public void rollback(Store store) {
        if (this.oldElement == null) {
            store.remove(this.getObjectKey());
        } else {
            store.put(this.oldElement);
        }
        SoftLock softLock = (SoftLock)this.softLockedElement.getObjectValue();
        softLock.unfreeze();
        softLock.unlock();
        this.softLockedElement = null;
    }

    private Element createElement(Object key, SoftLock softLock) {
        Element element = new Element(key, softLock);
        element.setEternal(true);
        return element;
    }
}

