/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema;

import java.util.List;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.model.schema.DescriptionUtils;
import org.apache.directory.shared.ldap.model.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.model.schema.registries.Registries;
import org.apache.directory.shared.ldap.model.schema.syntaxCheckers.OctetStringSyntaxChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapSyntax
extends AbstractSchemaObject {
    protected boolean isHumanReadable = false;
    protected SyntaxChecker syntaxChecker;

    public LdapSyntax(String oid) {
        super(SchemaObjectType.LDAP_SYNTAX, oid);
    }

    public LdapSyntax(String oid, String description) {
        super(SchemaObjectType.LDAP_SYNTAX, oid);
        this.description = description;
    }

    public LdapSyntax(String oid, String description, boolean isHumanReadable) {
        super(SchemaObjectType.LDAP_SYNTAX, oid);
        this.description = description;
        this.isHumanReadable = isHumanReadable;
    }

    public boolean isHumanReadable() {
        return this.isHumanReadable;
    }

    public void setHumanReadable(boolean humanReadable) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.isHumanReadable = humanReadable;
        }
    }

    public SyntaxChecker getSyntaxChecker() {
        return this.syntaxChecker;
    }

    public void setSyntaxChecker(SyntaxChecker syntaxChecker) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.syntaxChecker = syntaxChecker;
        }
    }

    public void updateSyntaxChecker(SyntaxChecker newSyntaxChecker) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        this.syntaxChecker = newSyntaxChecker;
    }

    public String toString() {
        return (Object)((Object)this.objectType) + " " + DescriptionUtils.getDescription(this);
    }

    @Override
    public void addToRegistries(List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null) {
            try {
                this.syntaxChecker = (SyntaxChecker)registries.getSyntaxCheckerRegistry().lookup(this.oid);
            }
            catch (LdapException ne) {
                this.syntaxChecker = new OctetStringSyntaxChecker(this.oid);
            }
            if (this.syntaxChecker != null) {
                registries.addReference(this, this.syntaxChecker);
            }
        }
    }

    @Override
    public void removeFromRegistries(List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null && this.syntaxChecker != null) {
            registries.delReference(this, this.syntaxChecker);
        }
    }

    @Override
    public LdapSyntax copy() {
        LdapSyntax copy = new LdapSyntax(this.oid);
        copy.copy(this);
        copy.isHumanReadable = this.isHumanReadable;
        copy.syntaxChecker = null;
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof LdapSyntax)) {
            return false;
        }
        LdapSyntax that = (LdapSyntax)o;
        if (this.isHumanReadable != that.isHumanReadable) {
            return false;
        }
        if (this.syntaxChecker != null) {
            if (that.syntaxChecker == null) {
                return false;
            }
            return this.syntaxChecker.getOid().equals(that.syntaxChecker.getOid());
        }
        return that.syntaxChecker == null;
    }

    @Override
    public void clear() {
        super.clear();
        this.syntaxChecker = null;
    }
}

