/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.protocol.mina;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.tlv.TLVStateEnum;
import org.apache.directory.shared.ldap.codec.api.LdapDecoder;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.MessageDecorator;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.model.exception.ResponseCarryingMessageException;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.util.Strings;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapProtocolDecoder
implements ProtocolDecoder {
    private static Logger LOG = LoggerFactory.getLogger(LdapDecoder.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private Asn1Decoder asn1Decoder = new Asn1Decoder();

    @Override
    public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        LdapMessageContainer messageContainer = (LdapMessageContainer)session.getAttribute("messageContainer");
        if (session.containsAttribute("maxPDUSize")) {
            int maxPDUSize = (Integer)session.getAttribute("maxPDUSize");
            messageContainer.setMaxPDUSize(maxPDUSize);
        }
        ArrayList<Message> decodedMessages = new ArrayList<Message>();
        ByteBuffer buf = in.buf();
        this.decode(buf, messageContainer, decodedMessages);
        for (Message message : decodedMessages) {
            out.write(message);
        }
    }

    private void decode(ByteBuffer buffer, LdapMessageContainer<MessageDecorator<? extends Message>> messageContainer, List<Message> decodedMessages) throws DecoderException {
        buffer.mark();
        while (buffer.hasRemaining()) {
            try {
                if (IS_DEBUG) {
                    LOG.debug("Decoding the PDU : ");
                    int size = buffer.limit();
                    int position = buffer.position();
                    int pduLength = size - position;
                    byte[] array = new byte[pduLength];
                    System.arraycopy(buffer.array(), position, array, 0, pduLength);
                    buffer.position(size);
                    if (array.length == 0) {
                        LOG.debug("NULL buffer, what the HELL ???");
                    } else {
                        LOG.debug(Strings.dumpBytes(array));
                    }
                    buffer.reset();
                }
                this.asn1Decoder.decode(buffer, messageContainer);
                if (messageContainer.getState() != TLVStateEnum.PDU_DECODED) continue;
                if (IS_DEBUG) {
                    LOG.debug("Decoded LdapMessage : " + messageContainer.getMessage());
                }
                MessageDecorator<? extends Message> message = messageContainer.getMessage();
                decodedMessages.add(message);
                messageContainer.clean();
            }
            catch (DecoderException de) {
                buffer.clear();
                messageContainer.clean();
                if (de instanceof ResponseCarryingException) {
                    ResponseCarryingMessageException rcme = new ResponseCarryingMessageException(de.getMessage());
                    rcme.setResponse(((ResponseCarryingException)de).getResponse());
                    throw rcme;
                }
                throw new ResponseCarryingException(de.getMessage());
            }
        }
    }

    @Override
    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }

    @Override
    public void dispose(IoSession session) throws Exception {
    }
}

