/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.padata.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.padata.PaDataContainer;
import org.apache.directory.shared.kerberos.codec.types.PaDataType;
import org.apache.directory.shared.kerberos.components.PaData;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreDataType
extends GrammarAction<PaDataContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreDataType.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreDataType() {
        super("PaDataData's padata-type");
    }

    @Override
    public void action(PaDataContainer paDataContainer) throws DecoderException {
        TLV tlv = paDataContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err(I18n.ERR_04066, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_04067, new Object[0]));
        }
        PaData paData = paDataContainer.getPaData();
        Value value = tlv.getValue();
        try {
            int paDataType = IntegerDecoder.parse(value);
            paData.setPaDataType(PaDataType.getTypeByValue(paDataType));
            if (IS_DEBUG) {
                LOG.debug("padata-type : {}", paDataType);
            }
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err(I18n.ERR_04070, Strings.dumpBytes(value.getData()), ide.getLocalizedMessage()));
            throw new DecoderException(ide.getMessage());
        }
    }
}

