/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.Iterator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.LeafEvaluator;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public class GreaterEqEvaluator<T, ID extends Comparable<ID>>
extends LeafEvaluator<T, ID> {
    public GreaterEqEvaluator(GreaterEqNode<T> node, Store<Entry, ID> db, SchemaManager schemaManager) throws Exception {
        super(node, db, schemaManager);
        this.idx = db.hasIndexOn(node.getAttributeType()) ? db.getIndex(this.attributeType) : null;
        MatchingRule mr = this.attributeType.getOrdering();
        if (mr == null) {
            mr = this.attributeType.getEquality();
        }
        if (mr == null) {
            throw new IllegalStateException(I18n.err(I18n.ERR_715, node));
        }
        this.normalizer = mr.getNormalizer();
        this.ldapComparator = mr.getLdapComparator();
    }

    @Override
    public GreaterEqNode getExpression() {
        return (GreaterEqNode)this.node;
    }

    @Override
    public boolean evaluate(IndexEntry<?, ID> indexEntry) throws Exception {
        Attribute attr;
        if (this.idx != null && this.idx.isDupsEnabled()) {
            return this.idx.reverseGreaterOrEq(indexEntry.getId(), this.node.getValue().getValue());
        }
        Entry entry = indexEntry.getEntry();
        if (null == entry) {
            entry = this.db.lookup((Comparable)indexEntry.getId());
            indexEntry.setEntry(entry);
        }
        if ((attr = entry.get(this.attributeType)) != null && this.evaluate(indexEntry, attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = entry.get(descendant);
                if (attr == null || !this.evaluate(indexEntry, attr)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean evaluateId(ID id) throws Exception {
        if (this.idx != null && this.idx.isDupsEnabled()) {
            return this.idx.reverseGreaterOrEq(id, this.node.getValue().getValue());
        }
        return this.evaluateEntry(this.db.lookup(id));
    }

    @Override
    public boolean evaluateEntry(Entry entry) throws Exception {
        Attribute attr = entry.get(this.attributeType);
        if (attr != null && this.evaluate(null, attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = entry.get(descendant);
                if (attr == null || !this.evaluate(null, attr)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean evaluate(IndexEntry<Object, ID> indexEntry, Attribute attribute) throws Exception {
        for (Value value : attribute) {
            if (this.ldapComparator.compare(value.getNormValue(), this.node.getValue().getNormValue()) < 0) continue;
            if (indexEntry != null) {
                indexEntry.setValue(value.getNormValue());
            }
            return true;
        }
        return false;
    }
}

