/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.schema.DescriptionParsers;
import org.apache.directory.server.core.schema.SchemaSubentryModifier;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.DITContentRule;
import org.apache.directory.shared.ldap.model.schema.DITStructureRule;
import org.apache.directory.shared.ldap.model.schema.LdapSyntax;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.model.schema.NameForm;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.parsers.LdapComparatorDescription;
import org.apache.directory.shared.ldap.model.schema.parsers.NormalizerDescription;
import org.apache.directory.shared.ldap.model.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaSubentryManager {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaSubentryManager.class);
    private static final int COMPARATOR_INDEX = 0;
    private static final int NORMALIZER_INDEX = 1;
    private static final int SYNTAX_CHECKER_INDEX = 2;
    private static final int SYNTAX_INDEX = 3;
    private static final int MATCHING_RULE_INDEX = 4;
    private static final int ATTRIBUTE_TYPE_INDEX = 5;
    private static final int OBJECT_CLASS_INDEX = 6;
    private static final int MATCHING_RULE_USE_INDEX = 7;
    private static final int DIT_STRUCTURE_RULE_INDEX = 8;
    private static final int DIT_CONTENT_RULE_INDEX = 9;
    private static final int NAME_FORM_INDEX = 10;
    private static final Set<String> VALID_OU_VALUES = new HashSet<String>();
    private final SchemaManager schemaManager;
    private final SchemaSubentryModifier subentryModifier;
    private final DescriptionParsers parsers;
    private final Map<String, Integer> opAttr2handlerIndex = new HashMap<String, Integer>(11);
    private static final String CASCADING_ERROR = "Cascading has not yet been implemented: standard operation is in effect.";
    private static AttributeType ENTRY_CSN_ATTRIBUTE_TYPE;

    public SchemaSubentryManager(SchemaManager schemaManager, SchemaLoader loader, DnFactory dnFactory) throws LdapException {
        this.schemaManager = schemaManager;
        this.subentryModifier = new SchemaSubentryModifier(schemaManager, dnFactory);
        this.parsers = new DescriptionParsers(schemaManager);
        String comparatorsOid = schemaManager.getAttributeTypeRegistry().getOidByName("comparators");
        this.opAttr2handlerIndex.put(comparatorsOid, 0);
        String normalizersOid = schemaManager.getAttributeTypeRegistry().getOidByName("normalizers");
        this.opAttr2handlerIndex.put(normalizersOid, 1);
        String syntaxCheckersOid = schemaManager.getAttributeTypeRegistry().getOidByName("syntaxCheckers");
        this.opAttr2handlerIndex.put(syntaxCheckersOid, 2);
        String ldapSyntaxesOid = schemaManager.getAttributeTypeRegistry().getOidByName("ldapSyntaxes");
        this.opAttr2handlerIndex.put(ldapSyntaxesOid, 3);
        String matchingRulesOid = schemaManager.getAttributeTypeRegistry().getOidByName("matchingRules");
        this.opAttr2handlerIndex.put(matchingRulesOid, 4);
        String attributeTypesOid = schemaManager.getAttributeTypeRegistry().getOidByName("attributeTypes");
        this.opAttr2handlerIndex.put(attributeTypesOid, 5);
        String objectClassesOid = schemaManager.getAttributeTypeRegistry().getOidByName("objectClasses");
        this.opAttr2handlerIndex.put(objectClassesOid, 6);
        String matchingRuleUseOid = schemaManager.getAttributeTypeRegistry().getOidByName("matchingRuleUse");
        this.opAttr2handlerIndex.put(matchingRuleUseOid, 7);
        String ditStructureRulesOid = schemaManager.getAttributeTypeRegistry().getOidByName("ditStructureRules");
        this.opAttr2handlerIndex.put(ditStructureRulesOid, 8);
        String ditContentRulesOid = schemaManager.getAttributeTypeRegistry().getOidByName("ditContentRules");
        this.opAttr2handlerIndex.put(ditContentRulesOid, 9);
        String nameFormsOid = schemaManager.getAttributeTypeRegistry().getOidByName("nameForms");
        this.opAttr2handlerIndex.put(nameFormsOid, 10);
        ENTRY_CSN_ATTRIBUTE_TYPE = schemaManager.getAttributeType("entryCSN");
    }

    private Interceptor findNextInterceptor(OperationEnum operation, DirectoryService directoryService) {
        Interceptor interceptor = null;
        List<Interceptor> allInterceptors = directoryService.getInterceptors();
        List<String> operationInterceptors = directoryService.getInterceptors(operation);
        int position = 0;
        String addInterceptor = operationInterceptors.get(position);
        for (Interceptor inter : allInterceptors) {
            String interName = inter.getName();
            if (interName.equals(InterceptorEnum.SCHEMA_INTERCEPTOR.getName())) {
                if (++position >= operationInterceptors.size()) break;
                interceptor = directoryService.getInterceptor(operationInterceptors.get(position));
                break;
            }
            if (!interName.equals(addInterceptor)) continue;
            addInterceptor = operationInterceptors.get(++position);
        }
        return interceptor;
    }

    private int findPosition(OperationEnum operation, Interceptor interceptor, DirectoryService directoryService) {
        int position = 1;
        List<String> interceptors = directoryService.getInterceptors(operation);
        String interceptorName = interceptor.getName();
        for (String name : interceptors) {
            if (name.equals(interceptorName)) break;
            ++position;
        }
        return position;
    }

    public void modifySchemaSubentry(ModifyOperationContext modifyContext, boolean doCascadeModify) throws LdapException {
        DirectoryService directoryService = modifyContext.getSession().getDirectoryService();
        Interceptor nextAdd = this.findNextInterceptor(OperationEnum.ADD, directoryService);
        int positionAdd = this.findPosition(OperationEnum.ADD, nextAdd, directoryService);
        Interceptor nextDelete = this.findNextInterceptor(OperationEnum.DELETE, directoryService);
        int positionDelete = this.findPosition(OperationEnum.DELETE, nextDelete, directoryService);
        for (Modification mod : modifyContext.getModItems()) {
            String opAttrOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mod.getAttribute().getId());
            Attribute serverAttribute = mod.getAttribute();
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    this.modifyAddOperation(nextAdd, positionAdd, modifyContext, opAttrOid, serverAttribute, doCascadeModify);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    this.modifyRemoveOperation(nextDelete, positionDelete, modifyContext, opAttrOid, serverAttribute);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    if (ENTRY_CSN_ATTRIBUTE_TYPE.equals(serverAttribute.getAttributeType())) break;
                    throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_283, new Object[0]));
                }
                default: {
                    throw new IllegalStateException(I18n.err(I18n.ERR_284, new Object[]{mod.getOperation()}));
                }
            }
        }
    }

    private void modifyRemoveOperation(Interceptor nextInterceptor, int position, ModifyOperationContext modifyContext, String opAttrOid, Attribute mods) throws LdapException {
        int index = this.opAttr2handlerIndex.get(opAttrOid);
        switch (index) {
            case 0: {
                LdapComparatorDescription[] comparatorDescriptions;
                for (LdapComparatorDescription comparatorDescription : comparatorDescriptions = this.parsers.parseComparators(mods)) {
                    this.subentryModifier.delete(nextInterceptor, position, modifyContext, comparatorDescription);
                }
                break;
            }
            case 1: {
                NormalizerDescription[] normalizerDescriptions;
                for (NormalizerDescription normalizerDescription : normalizerDescriptions = this.parsers.parseNormalizers(mods)) {
                    this.subentryModifier.delete(nextInterceptor, position, modifyContext, normalizerDescription);
                }
                break;
            }
            case 2: {
                SyntaxCheckerDescription[] syntaxCheckerDescriptions;
                for (SyntaxCheckerDescription syntaxCheckerDescription : syntaxCheckerDescriptions = this.parsers.parseSyntaxCheckers(mods)) {
                    this.subentryModifier.delete(nextInterceptor, position, modifyContext, syntaxCheckerDescription);
                }
                break;
            }
            case 3: {
                LdapSyntax[] syntaxes;
                for (LdapSyntax syntax : syntaxes = this.parsers.parseLdapSyntaxes(mods)) {
                    this.subentryModifier.deleteSchemaObject(nextInterceptor, position, modifyContext, syntax);
                }
                break;
            }
            case 4: {
                MatchingRule[] mrs;
                for (MatchingRule mr : mrs = this.parsers.parseMatchingRules(mods)) {
                    this.subentryModifier.deleteSchemaObject(nextInterceptor, position, modifyContext, mr);
                }
                break;
            }
            case 5: {
                AttributeType[] ats;
                for (AttributeType at : ats = this.parsers.parseAttributeTypes(mods)) {
                    this.subentryModifier.deleteSchemaObject(nextInterceptor, position, modifyContext, at);
                }
                break;
            }
            case 6: {
                ObjectClass[] ocs;
                for (ObjectClass oc : ocs = this.parsers.parseObjectClasses(mods)) {
                    this.subentryModifier.deleteSchemaObject(nextInterceptor, position, modifyContext, oc);
                }
                break;
            }
            case 7: {
                MatchingRuleUse[] mrus;
                for (MatchingRuleUse mru : mrus = this.parsers.parseMatchingRuleUses(mods)) {
                    this.subentryModifier.deleteSchemaObject(nextInterceptor, position, modifyContext, mru);
                }
                break;
            }
            case 8: {
                DITStructureRule[] dsrs;
                for (DITStructureRule dsr : dsrs = this.parsers.parseDitStructureRules(mods)) {
                    this.subentryModifier.deleteSchemaObject(nextInterceptor, position, modifyContext, dsr);
                }
                break;
            }
            case 9: {
                DITContentRule[] dcrs;
                for (DITContentRule dcr : dcrs = this.parsers.parseDitContentRules(mods)) {
                    this.subentryModifier.deleteSchemaObject(nextInterceptor, position, modifyContext, dcr);
                }
                break;
            }
            case 10: {
                NameForm[] nfs;
                for (NameForm nf : nfs = this.parsers.parseNameForms(mods)) {
                    this.subentryModifier.deleteSchemaObject(nextInterceptor, position, modifyContext, nf);
                }
                break;
            }
            default: {
                throw new IllegalStateException(I18n.err(I18n.ERR_285, index));
            }
        }
    }

    private void modifyAddOperation(Interceptor nextInterceptor, int position, ModifyOperationContext modifyContext, String opAttrOid, Attribute mods, boolean doCascadeModify) throws LdapException {
        if (doCascadeModify) {
            LOG.error(CASCADING_ERROR);
        }
        int index = this.opAttr2handlerIndex.get(opAttrOid);
        switch (index) {
            case 0: {
                LdapComparatorDescription[] comparatorDescriptions;
                for (LdapComparatorDescription comparatorDescription : comparatorDescriptions = this.parsers.parseComparators(mods)) {
                    this.subentryModifier.add(nextInterceptor, position, modifyContext, comparatorDescription);
                }
                break;
            }
            case 1: {
                NormalizerDescription[] normalizerDescriptions;
                for (NormalizerDescription normalizerDescription : normalizerDescriptions = this.parsers.parseNormalizers(mods)) {
                    this.subentryModifier.add(nextInterceptor, position, modifyContext, normalizerDescription);
                }
                break;
            }
            case 2: {
                SyntaxCheckerDescription[] syntaxCheckerDescriptions;
                for (SyntaxCheckerDescription syntaxCheckerDescription : syntaxCheckerDescriptions = this.parsers.parseSyntaxCheckers(mods)) {
                    this.subentryModifier.add(nextInterceptor, position, modifyContext, syntaxCheckerDescription);
                }
                break;
            }
            case 3: {
                LdapSyntax[] syntaxes;
                for (LdapSyntax syntax : syntaxes = this.parsers.parseLdapSyntaxes(mods)) {
                    this.subentryModifier.addSchemaObject(nextInterceptor, position, modifyContext, syntax);
                }
                break;
            }
            case 4: {
                MatchingRule[] mrs;
                for (MatchingRule mr : mrs = this.parsers.parseMatchingRules(mods)) {
                    this.subentryModifier.addSchemaObject(nextInterceptor, position, modifyContext, mr);
                }
                break;
            }
            case 5: {
                AttributeType[] ats;
                for (AttributeType at : ats = this.parsers.parseAttributeTypes(mods)) {
                    this.subentryModifier.addSchemaObject(nextInterceptor, position, modifyContext, at);
                }
                break;
            }
            case 6: {
                ObjectClass[] ocs;
                for (ObjectClass oc : ocs = this.parsers.parseObjectClasses(mods)) {
                    this.subentryModifier.addSchemaObject(nextInterceptor, position, modifyContext, oc);
                }
                break;
            }
            case 7: {
                MatchingRuleUse[] mrus;
                for (MatchingRuleUse mru : mrus = this.parsers.parseMatchingRuleUses(mods)) {
                    this.subentryModifier.addSchemaObject(nextInterceptor, position, modifyContext, mru);
                }
                break;
            }
            case 8: {
                DITStructureRule[] dsrs;
                for (DITStructureRule dsr : dsrs = this.parsers.parseDitStructureRules(mods)) {
                    this.subentryModifier.addSchemaObject(nextInterceptor, position, modifyContext, dsr);
                }
                break;
            }
            case 9: {
                DITContentRule[] dcrs;
                for (DITContentRule dcr : dcrs = this.parsers.parseDitContentRules(mods)) {
                    this.subentryModifier.addSchemaObject(nextInterceptor, position, modifyContext, dcr);
                }
                break;
            }
            case 10: {
                NameForm[] nfs;
                for (NameForm nf : nfs = this.parsers.parseNameForms(mods)) {
                    this.subentryModifier.addSchemaObject(nextInterceptor, position, modifyContext, nf);
                }
                break;
            }
            default: {
                throw new IllegalStateException(I18n.err(I18n.ERR_285, index));
            }
        }
    }

    static {
        VALID_OU_VALUES.add(Strings.toLowerCase("normalizers"));
        VALID_OU_VALUES.add(Strings.toLowerCase("comparators"));
        VALID_OU_VALUES.add(Strings.toLowerCase("syntaxCheckers"));
        VALID_OU_VALUES.add(Strings.toLowerCase("syntaxes"));
        VALID_OU_VALUES.add(Strings.toLowerCase("matchingRules"));
        VALID_OU_VALUES.add(Strings.toLowerCase("matchingRuleUse"));
        VALID_OU_VALUES.add(Strings.toLowerCase("attributeTypes"));
        VALID_OU_VALUES.add(Strings.toLowerCase("objectClasses"));
        VALID_OU_VALUES.add(Strings.toLowerCase("nameForms"));
        VALID_OU_VALUES.add(Strings.toLowerCase("ditContentRules"));
        VALID_OU_VALUES.add(Strings.toLowerCase("ditStructureRules"));
    }
}

