/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn.ppolicy;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyConfiguration;
import org.apache.directory.shared.ldap.model.name.Dn;

public class PpolicyConfigContainer {
    private Map<Dn, PasswordPolicyConfiguration> ppolicyConfigMap = new HashMap<Dn, PasswordPolicyConfiguration>();
    private PasswordPolicyConfiguration defaultPolicy;

    public void addPolicy(Dn configDn, PasswordPolicyConfiguration policyConfig) {
        if (configDn == null) {
            throw new IllegalArgumentException("password policy config's Dn cannot be null");
        }
        this.ppolicyConfigMap.put(configDn, policyConfig);
    }

    public boolean hasCustomConfigs() {
        return !this.ppolicyConfigMap.isEmpty();
    }

    public PasswordPolicyConfiguration getPolicyConfig(Dn configDn) {
        return this.ppolicyConfigMap.get(configDn);
    }

    public PasswordPolicyConfiguration getDefaultPolicy() {
        return this.defaultPolicy;
    }

    public void setDefaultPolicy(PasswordPolicyConfiguration defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
    }

    public PasswordPolicyConfiguration removePolicyConfig(Dn ppolicyConfigDn) {
        return this.ppolicyConfigMap.remove(ppolicyConfigDn);
    }
}

