/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.event;

import java.util.ArrayList;

public enum EventType {
    ADD(1),
    DELETE(2),
    MODIFY(4),
    RENAME(8),
    MOVE(16);

    public static final int ALL_EVENT_TYPES_MASK;
    public static final int MOVE_AND_RENAME_MASK;
    private static final EventType[] EMPTY_EVENT_ARRAY;
    private int mask;

    private EventType(int mask) {
        this.mask = mask;
    }

    public int getMask() {
        return this.mask;
    }

    public static EventType[] getEventTypes(int psearchChangeTypes) {
        ArrayList<EventType> types = new ArrayList<EventType>();
        if (EventType.isAdd(psearchChangeTypes)) {
            types.add(ADD);
        }
        if (EventType.isDelete(psearchChangeTypes)) {
            types.add(DELETE);
        }
        if (EventType.isModify(psearchChangeTypes)) {
            types.add(MODIFY);
        }
        if ((psearchChangeTypes & 8) > 0) {
            types.add(MOVE);
            types.add(RENAME);
        }
        return types.toArray(EMPTY_EVENT_ARRAY);
    }

    private static int getAllEventTypesMask() {
        int allTypes = 0;
        for (EventType type : EventType.values()) {
            allTypes |= type.getMask();
        }
        return allTypes;
    }

    public static boolean isAdd(int mask) {
        return (mask & EventType.ADD.mask) != 0;
    }

    public static boolean isDelete(int mask) {
        return (mask & EventType.DELETE.mask) != 0;
    }

    public static boolean isModify(int mask) {
        return (mask & EventType.MODIFY.mask) != 0;
    }

    public static boolean isMove(int mask) {
        return (mask & EventType.MOVE.mask) != 0;
    }

    public static boolean isRename(int mask) {
        return (mask & EventType.RENAME.mask) != 0;
    }

    public static boolean isMoveAndRename(int mask) {
        return (mask & MOVE_AND_RENAME_MASK) != 0;
    }

    public static int getMask(EventType ... eventTypes) {
        int mask = 0;
        for (EventType type : eventTypes) {
            mask |= type.getMask();
        }
        return mask;
    }

    public static EventType getType(int mask) {
        switch (mask) {
            case 1: {
                return ADD;
            }
            case 2: {
                return DELETE;
            }
            case 4: {
                return MODIFY;
            }
            case 8: {
                return RENAME;
            }
            case 16: {
                return MOVE;
            }
        }
        throw new IllegalArgumentException("unknown mask value " + mask);
    }

    public static String toString(int mask) {
        switch (mask) {
            case 0: {
                return "no event";
            }
            case 1: {
                return "ADD";
            }
            case 2: {
                return "DELETE";
            }
            case 4: {
                return "MODIFY";
            }
            case 8: {
                return "RENAME";
            }
            case 16: {
                return "MOVE";
            }
            case 24: {
                return "MOVE_AND_RENAME";
            }
            case 31: {
                return "ALL EVENTS";
            }
        }
        return "Unknown";
    }

    static {
        ALL_EVENT_TYPES_MASK = EventType.getAllEventTypesMask();
        MOVE_AND_RENAME_MASK = EventType.MOVE.mask | EventType.RENAME.mask;
        EMPTY_EVENT_ARRAY = new EventType[0];
    }
}

