/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.api.MessageDecorator;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.SearchResultEntry;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultEntryDecorator
extends MessageDecorator<SearchResultEntry>
implements SearchResultEntry {
    private byte[] objectNameBytes;
    private int searchResultEntryLength;
    private int attributesLength;
    private List<Integer> attributeLength;
    private List<Integer> valsLength;
    private Attribute currentAttribute;

    public SearchResultEntryDecorator(LdapApiService codec, SearchResultEntry decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public byte[] getObjectNameBytes() {
        return this.objectNameBytes;
    }

    public void setObjectNameBytes(byte[] objectNameBytes) {
        this.objectNameBytes = objectNameBytes;
    }

    public int getSearchResultEntryLength() {
        return this.searchResultEntryLength;
    }

    public void setSearchResultEntryLength(int searchResultEntryLength) {
        this.searchResultEntryLength = searchResultEntryLength;
    }

    public int getAttributesLength() {
        return this.attributesLength;
    }

    public void setAttributesLength(int attributesLength) {
        this.attributesLength = attributesLength;
    }

    public List<Integer> getAttributeLength() {
        return this.attributeLength;
    }

    public void setAttributeLength(List<Integer> attributeLength) {
        this.attributeLength = attributeLength;
    }

    public List<Integer> getValsLength() {
        return this.valsLength;
    }

    public void setValsLength(List<Integer> valsLength) {
        this.valsLength = valsLength;
    }

    public Attribute getCurrentAttribute() {
        return this.currentAttribute;
    }

    public void addAttribute(String type) throws LdapException {
        this.currentAttribute = new DefaultAttribute(type);
        ((SearchResultEntry)this.getDecorated()).getEntry().put(this.currentAttribute);
    }

    public void addAttributeValue(Object value) throws LdapException {
        if (value instanceof String) {
            this.currentAttribute.add((String)value);
        } else {
            this.currentAttribute.add(new byte[][]{(byte[])value});
        }
    }

    @Override
    public Dn getObjectName() {
        return ((SearchResultEntry)this.getDecorated()).getObjectName();
    }

    @Override
    public void setObjectName(Dn objectName) {
        ((SearchResultEntry)this.getDecorated()).setObjectName(objectName);
    }

    @Override
    public Entry getEntry() {
        return ((SearchResultEntry)this.getDecorated()).getEntry();
    }

    @Override
    public void setEntry(Entry entry) {
        ((SearchResultEntry)this.getDecorated()).setEntry(entry);
    }

    @Override
    public int computeLength() {
        Dn dn = this.getObjectName();
        byte[] dnBytes = Strings.getBytesUtf8(dn.getName());
        int searchResultEntryLength = 1 + TLV.getNbBytes(dnBytes.length) + dnBytes.length;
        this.setObjectNameBytes(dnBytes);
        int attributesLength = 0;
        Entry entry = this.getEntry();
        if (entry != null && entry.size() != 0) {
            LinkedList<Integer> attributeLength = new LinkedList<Integer>();
            LinkedList<Integer> valsLength = new LinkedList<Integer>();
            this.setAttributeLength(attributeLength);
            this.setValsLength(valsLength);
            for (Attribute attribute : entry) {
                int localAttributeLength = 0;
                int localValuesLength = 0;
                int idLength = attribute.getUpId().getBytes().length;
                localAttributeLength = 1 + TLV.getNbBytes(idLength) + idLength;
                if (attribute.size() != 0) {
                    if (attribute.size() > 0) {
                        localValuesLength = 0;
                        for (Value value : attribute) {
                            byte[] binaryValue = value.getBytes();
                            localValuesLength += 1 + TLV.getNbBytes(binaryValue.length) + binaryValue.length;
                        }
                        localAttributeLength += 1 + TLV.getNbBytes(localValuesLength) + localValuesLength;
                    } else {
                        localAttributeLength += 2;
                    }
                } else {
                    localAttributeLength += 2;
                }
                attributesLength += 1 + TLV.getNbBytes(localAttributeLength) + localAttributeLength;
                attributeLength.add(localAttributeLength);
                valsLength.add(localValuesLength);
            }
            this.setAttributesLength(attributesLength);
        }
        this.setSearchResultEntryLength(searchResultEntryLength += 1 + TLV.getNbBytes(attributesLength) + attributesLength);
        return 1 + TLV.getNbBytes(searchResultEntryLength) + searchResultEntryLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)100);
            buffer.put(TLV.getBytes(this.getSearchResultEntryLength()));
            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, this.getObjectNameBytes());
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes(this.getAttributesLength()));
            Entry entry = this.getEntry();
            if (entry != null && entry.size() != 0) {
                int attributeNumber = 0;
                for (Attribute attribute : entry) {
                    buffer.put(UniversalTag.SEQUENCE.getValue());
                    int localAttributeLength = this.getAttributeLength().get(attributeNumber);
                    buffer.put(TLV.getBytes(localAttributeLength));
                    org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, Asn1StringUtils.asciiStringToByte(attribute.getUpId()));
                    buffer.put(UniversalTag.SET.getValue());
                    int localValuesLength = this.getValsLength().get(attributeNumber);
                    buffer.put(TLV.getBytes(localValuesLength));
                    if (attribute.size() > 0) {
                        for (Value value : attribute) {
                            if (value.isHumanReadable()) {
                                org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, value.getString());
                                continue;
                            }
                            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, value.getBytes());
                        }
                    }
                    ++attributeNumber;
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }
}

