/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.bindRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.BindRequestDecorator;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreVersion
extends GrammarAction<LdapMessageContainer<BindRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreVersion.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreVersion() {
        super("Store BindRequest Version");
    }

    @Override
    public void action(LdapMessageContainer<BindRequestDecorator> container) throws DecoderException {
        BindRequest bindRequestMessage = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Value value = tlv.getValue();
        try {
            int version = IntegerDecoder.parse(value, 1, 127);
            if (IS_DEBUG) {
                LOG.debug("Ldap version ", version);
            }
            bindRequestMessage.setVersion3(version == 3);
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err(I18n.ERR_04078, Strings.dumpBytes(value.getData()), ide.getMessage()));
            throw new DecoderException(ide.getMessage());
        }
    }
}

