/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.addRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.decorators.AddRequestDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.AddResponseImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAddRequestAttributeType
extends GrammarAction<LdapMessageContainer<AddRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddAddRequestAttributeType.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AddAddRequestAttributeType() {
        super("Store attribute type");
    }

    @Override
    public void action(LdapMessageContainer<AddRequestDecorator> container) throws DecoderException {
        AddRequestDecorator addRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_04086, new Object[0]);
            LOG.error(msg);
            AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
            throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, addRequest.getEntry().getDn(), null);
        }
        String type = Strings.utf8ToString(tlv.getValue().getData());
        try {
            addRequest.addAttributeType(type);
        }
        catch (LdapException ne) {
            String msg = I18n.err(I18n.ERR_04087, new Object[0]);
            LOG.error(msg);
            AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
            throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, addRequest.getEntry().getDn(), ne);
        }
        if (IS_DEBUG) {
            LOG.debug("Adding type {}", (Object)type);
        }
    }
}

