/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.kdcReqBody.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.kdcReqBody.KdcReqBodyContainer;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.KdcReqBody;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddEType
extends GrammarAction<KdcReqBodyContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AddEType.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AddEType() {
        super("KDC-REQ-BODY AddEType");
    }

    @Override
    public void action(KdcReqBodyContainer kdcReqBodyContainer) throws DecoderException {
        TLV tlv = kdcReqBodyContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err(I18n.ERR_04066, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_04067, new Object[0]));
        }
        KdcReqBody kdcReqBody = kdcReqBodyContainer.getKdcReqBody();
        Value value = tlv.getValue();
        try {
            int etype = IntegerDecoder.parse(value);
            EncryptionType encryptionType = EncryptionType.getTypeByValue(etype);
            kdcReqBody.addEType(encryptionType);
            if (IS_DEBUG) {
                LOG.debug("EncryptionType : {}", (Object)encryptionType);
            }
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err(I18n.ERR_04070, Strings.dumpBytes(value.getData()), ide.getLocalizedMessage()));
            throw new DecoderException(ide.getMessage());
        }
        kdcReqBodyContainer.setGrammarEndAllowed(true);
    }
}

