/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.sp.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.sp.StoredProcEngine;
import org.apache.directory.server.core.sp.StoredProcUtils;
import org.apache.directory.server.core.sp.java.LdapJavaStoredProcClassLoader;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.util.MethodUtils;

public class JavaStoredProcEngine
implements StoredProcEngine {
    public static final String STORED_PROC_LANG_ID = "Java";
    private Entry spUnit;
    private static Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    @Override
    public Object invokeProcedure(CoreSession session, String fullSPName, Object[] spArgs) throws LdapException {
        Method proc;
        Class<?> clazz;
        Attribute javaByteCode = this.spUnit.get("javaByteCode");
        String spName = StoredProcUtils.extractStoredProcName(fullSPName);
        String className = StoredProcUtils.extractStoredProcUnitName(fullSPName);
        LdapJavaStoredProcClassLoader loader = new LdapJavaStoredProcClassLoader(javaByteCode);
        try {
            clazz = loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new LdapException(e);
        }
        Class<?>[] types = this.getTypesFromValues(spArgs);
        try {
            proc = MethodUtils.getAssignmentCompatibleMethod(clazz, spName, types);
        }
        catch (NoSuchMethodException e) {
            throw new LdapException(e);
        }
        try {
            return proc.invoke(null, spArgs);
        }
        catch (IllegalArgumentException e) {
            throw new LdapException(e);
        }
        catch (IllegalAccessException e) {
            throw new LdapException(e);
        }
        catch (InvocationTargetException e) {
            throw new LdapException(e);
        }
    }

    @Override
    public String getSPLangId() {
        return STORED_PROC_LANG_ID;
    }

    @Override
    public void setSPUnitEntry(Entry spUnit) {
        this.spUnit = spUnit;
    }

    private Class<?>[] getTypesFromValues(Object[] values) {
        ArrayList types = new ArrayList();
        for (Object obj : values) {
            types.add(obj.getClass());
        }
        return types.toArray(EMPTY_CLASS_ARRAY);
    }
}

