/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.referral;

import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.ReferralManager;
import org.apache.directory.server.core.ReferralManagerImpl;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.url.LdapUrl;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferralInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ReferralInterceptor.class);
    private PartitionNexus nexus;
    private ReferralManager referralManager;
    private Dn subschemaSubentryDn;

    private static void checkRefAttributeValue(Value<?> value) throws LdapException, LdapURLEncodingException {
        StringValue ref = (StringValue)value;
        String refVal = ref.getString();
        LdapUrl ldapUrl = new LdapUrl(refVal);
        if (ldapUrl.getScope() != SearchScope.OBJECT) {
            String message = I18n.err(I18n.ERR_36, new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        if (!Strings.isEmpty(ldapUrl.getFilter())) {
            String message = I18n.err(I18n.ERR_37, new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        if (ldapUrl.getAttributes() != null && ldapUrl.getAttributes().size() != 0) {
            String message = I18n.err(I18n.ERR_38, new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        if (ldapUrl.getExtensions() != null && ldapUrl.getExtensions().size() != 0) {
            String message = I18n.err(I18n.ERR_39, new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        if (ldapUrl.getExtensions() != null && ldapUrl.getExtensions().size() != 0) {
            String message = I18n.err(I18n.ERR_40, new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        Dn dn = ldapUrl.getDn();
        if (dn == null || dn.isEmpty()) {
            String message = I18n.err(I18n.ERR_41, new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
    }

    private static boolean isReferral(Entry entry) throws LdapException {
        if (entry == null) {
            return false;
        }
        Attribute oc = entry.get(OBJECT_CLASS_AT);
        if (oc == null) {
            LOG.warn("could not find objectClass attribute in entry: " + entry);
            return false;
        }
        if (!oc.contains("referral")) {
            return false;
        }
        Attribute refAttr = entry.get("ref");
        if (refAttr == null) {
            String message = I18n.err(I18n.ERR_42, new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        for (Value value : refAttr) {
            try {
                ReferralInterceptor.checkRefAttributeValue(value);
            }
            catch (LdapURLEncodingException luee) {}
        }
        return true;
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        this.referralManager = new ReferralManagerImpl(directoryService);
        directoryService.setReferralManager(this.referralManager);
        Value<?> subschemaSubentry = this.nexus.getRootDSE(null).get("subschemaSubentry").get();
        this.subschemaSubentryDn = directoryService.getDnFactory().create(subschemaSubentry.getString());
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws LdapException {
        Entry entry = addContext.getEntry();
        boolean isReferral = ReferralInterceptor.isReferral(entry);
        next.add(addContext);
        if (isReferral) {
            this.referralManager.lockWrite();
            this.referralManager.addReferral(entry);
            this.referralManager.unlock();
        }
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws LdapException {
        next.delete(deleteContext);
        Entry entry = deleteContext.getEntry();
        if (entry != null && ReferralInterceptor.isReferral(entry)) {
            this.referralManager.lockWrite();
            this.referralManager.removeReferral(entry);
            this.referralManager.unlock();
        }
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext moveContext) throws LdapException {
        Dn newDn = moveContext.getNewDn();
        boolean isReferral = ReferralInterceptor.isReferral(moveContext.getOriginalEntry());
        next.move(moveContext);
        if (isReferral) {
            this.referralManager.lockWrite();
            this.referralManager.addReferral(moveContext.getModifiedEntry());
            this.referralManager.removeReferral(moveContext.getOriginalEntry());
            this.referralManager.unlock();
        }
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        boolean isReferral = ReferralInterceptor.isReferral(moveAndRenameContext.getOriginalEntry());
        next.moveAndRename(moveAndRenameContext);
        if (isReferral) {
            Entry newEntry = moveAndRenameContext.getModifiedEntry();
            this.referralManager.lockWrite();
            this.referralManager.addReferral(newEntry);
            this.referralManager.removeReferral(moveAndRenameContext.getOriginalEntry());
            this.referralManager.unlock();
        }
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws LdapException {
        boolean isReferral = ReferralInterceptor.isReferral(renameContext.getOriginalEntry());
        next.rename(renameContext);
        if (isReferral) {
            LookupOperationContext lookupContext = new LookupOperationContext(renameContext.getSession(), renameContext.getNewDn());
            lookupContext.setAttrsId(SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            Entry newEntry = this.nexus.lookup(lookupContext);
            this.referralManager.lockWrite();
            this.referralManager.addReferral(newEntry);
            this.referralManager.removeReferral(((ClonedServerEntry)renameContext.getEntry()).getOriginalEntry());
            this.referralManager.unlock();
        }
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext modifyContext) throws LdapException {
        Dn dn = modifyContext.getDn();
        next.modify(modifyContext);
        if (dn.isEmpty() || dn.equals(this.subschemaSubentryDn)) {
            return;
        }
        LookupOperationContext lookupContext = new LookupOperationContext(modifyContext.getSession(), dn);
        lookupContext.setAttrsId(SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry newEntry = this.nexus.lookup(lookupContext);
        if (newEntry != null) {
            this.referralManager.lockWrite();
            if (this.referralManager.isReferral(newEntry.getDn())) {
                this.referralManager.removeReferral(modifyContext.getEntry());
                this.referralManager.addReferral(newEntry);
            }
            this.referralManager.unlock();
        }
    }
}

