/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.event.LeafEvaluator;
import org.apache.directory.server.core.event.SubstringEvaluator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidSearchFilterException;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.BranchNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.NotNode;
import org.apache.directory.shared.ldap.model.filter.OrNode;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public class ExpressionEvaluator
implements Evaluator {
    private LeafEvaluator leafEvaluator;

    public ExpressionEvaluator(LeafEvaluator leafEvaluator) {
        this.leafEvaluator = leafEvaluator;
    }

    public ExpressionEvaluator(SchemaManager schemaManager) {
        SubstringEvaluator substringEvaluator = null;
        substringEvaluator = new SubstringEvaluator();
        this.leafEvaluator = new LeafEvaluator(substringEvaluator);
    }

    public LeafEvaluator getLeafEvaluator() {
        return this.leafEvaluator;
    }

    @Override
    public boolean evaluate(ExprNode node, Dn dn, Entry entry) throws LdapException {
        if (node.isLeaf()) {
            return this.leafEvaluator.evaluate(node, dn, entry);
        }
        BranchNode bnode = (BranchNode)node;
        if (bnode instanceof OrNode) {
            for (ExprNode child : bnode.getChildren()) {
                if (!this.evaluate(child, dn, entry)) continue;
                return true;
            }
            return false;
        }
        if (bnode instanceof AndNode) {
            for (ExprNode child : bnode.getChildren()) {
                boolean res = this.evaluate(child, dn, entry);
                if (res) continue;
                return false;
            }
            return true;
        }
        if (bnode instanceof NotNode) {
            if (null != bnode.getFirstChild()) {
                return !this.evaluate(bnode.getFirstChild(), dn, entry);
            }
            throw new LdapInvalidSearchFilterException(I18n.err(I18n.ERR_243, node));
        }
        throw new LdapInvalidSearchFilterException(I18n.err(I18n.ERR_244, bnode));
    }
}

