/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.CacheService;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DnFactory;
import org.apache.directory.server.core.InstanceLayout;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.OperationManager;
import org.apache.directory.server.core.ReferralManager;
import org.apache.directory.server.core.administrative.AccessControlAdministrativePoint;
import org.apache.directory.server.core.administrative.CollectiveAttributeAdministrativePoint;
import org.apache.directory.server.core.administrative.SubschemaAdministrativePoint;
import org.apache.directory.server.core.administrative.TriggerExecutionAdministrativePoint;
import org.apache.directory.server.core.changelog.ChangeLog;
import org.apache.directory.server.core.entry.ServerEntryFactory;
import org.apache.directory.server.core.event.EventService;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.journal.Journal;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.schema.SchemaPartition;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.model.csn.Csn;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.util.tree.DnNode;

public interface DirectoryService
extends ServerEntryFactory {
    public static final String JNDI_KEY = DirectoryService.class.getName();

    public long revert(long var1) throws LdapException;

    public long revert() throws LdapException;

    public PartitionNexus getPartitionNexus();

    public InterceptorChain getInterceptorChain();

    public void addPartition(Partition var1) throws Exception;

    public void removePartition(Partition var1) throws Exception;

    public SchemaManager getSchemaManager();

    public LdapApiService getLdapCodecService();

    public ReferralManager getReferralManager();

    public void setReferralManager(ReferralManager var1);

    public SchemaPartition getSchemaPartition();

    public void setSchemaPartition(SchemaPartition var1);

    public EventService getEventService();

    public void setEventService(EventService var1);

    public void startup() throws Exception;

    public void shutdown() throws Exception;

    public void sync() throws Exception;

    public boolean isStarted();

    public CoreSession getAdminSession();

    public CoreSession getSession() throws Exception;

    public CoreSession getSession(LdapPrincipal var1) throws Exception;

    public CoreSession getSession(Dn var1, byte[] var2) throws LdapException;

    public CoreSession getSession(Dn var1, byte[] var2, String var3, String var4) throws Exception;

    public void setInstanceId(String var1);

    public String getInstanceId();

    public Set<? extends Partition> getPartitions();

    public void setPartitions(Set<? extends Partition> var1);

    public boolean isAccessControlEnabled();

    public void setAccessControlEnabled(boolean var1);

    public boolean isAllowAnonymousAccess();

    public boolean isPasswordHidden();

    public void setPasswordHidden(boolean var1);

    public void setAllowAnonymousAccess(boolean var1);

    public List<Interceptor> getInterceptors();

    public void setInterceptors(List<Interceptor> var1);

    public void setJournal(Journal var1);

    public List<LdifEntry> getTestEntries();

    public void setTestEntries(List<? extends LdifEntry> var1);

    public InstanceLayout getInstanceLayout();

    public void setInstanceLayout(InstanceLayout var1);

    public void setShutdownHookEnabled(boolean var1);

    public boolean isShutdownHookEnabled();

    public void setExitVmOnShutdown(boolean var1);

    public boolean isExitVmOnShutdown();

    public void setSystemPartition(Partition var1);

    public Partition getSystemPartition();

    public boolean isDenormalizeOpAttrsEnabled();

    public void setDenormalizeOpAttrsEnabled(boolean var1);

    public ChangeLog getChangeLog();

    public Journal getJournal();

    public void setChangeLog(ChangeLog var1);

    public Entry newEntry(String var1, String var2);

    public OperationManager getOperationManager();

    public int getMaxPDUSize();

    public void setMaxPDUSize(int var1);

    public Interceptor getInterceptor(String var1);

    public Csn getCSN();

    public int getReplicaId();

    public void setReplicaId(int var1);

    public void setSchemaManager(SchemaManager var1);

    public void setContextCsn(String var1);

    public String getContextCsn();

    public void setSyncPeriodMillis(long var1);

    public long getSyncPeriodMillis();

    public CacheService getCacheService();

    public DnNode<AccessControlAdministrativePoint> getAccessControlAPCache();

    public DnNode<CollectiveAttributeAdministrativePoint> getCollectiveAttributeAPCache();

    public DnNode<SubschemaAdministrativePoint> getSubschemaAPCache();

    public DnNode<TriggerExecutionAdministrativePoint> getTriggerExecutionAPCache();

    public boolean isPwdPolicyEnabled();

    public DnFactory getDnFactory();
}

