/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;
import org.apache.directory.server.i18n.I18n;

public class PageHeader
implements BlockView {
    private static final short O_MAGIC = 0;
    private static final short O_NEXT = 2;
    private static final short O_PREV = 10;
    protected static final short SIZE = 18;
    protected BlockIo blockIo;

    protected PageHeader(BlockIo blockIo) {
        this.blockIo = blockIo;
        blockIo.setView(this);
        if (!this.magicOk()) {
            throw new Error(I18n.err(I18n.ERR_546, blockIo.getBlockId(), this.getMagic()));
        }
    }

    PageHeader(BlockIo blockIo, short type) {
        this.blockIo = blockIo;
        blockIo.setView(this);
        this.setType(type);
    }

    static PageHeader getView(BlockIo blockIo) {
        BlockView view = blockIo.getView();
        if (view != null && view instanceof PageHeader) {
            return (PageHeader)view;
        }
        return new PageHeader(blockIo);
    }

    private boolean magicOk() {
        short magic = this.getMagic();
        return magic >= 4945 && magic <= 4949;
    }

    protected void paranoiaMagicOk() {
        if (!this.magicOk()) {
            throw new Error(I18n.err(I18n.ERR_547, this.getMagic()));
        }
    }

    short getMagic() {
        return this.blockIo.readShort(0);
    }

    long getNext() {
        this.paranoiaMagicOk();
        return this.blockIo.readLong(2);
    }

    void setNext(long next) {
        this.paranoiaMagicOk();
        this.blockIo.writeLong(2, next);
    }

    long getPrev() {
        this.paranoiaMagicOk();
        return this.blockIo.readLong(10);
    }

    void setPrev(long prev) {
        this.paranoiaMagicOk();
        this.blockIo.writeLong(10, prev);
    }

    void setType(short type) {
        this.blockIo.writeShort(0, (short)(4945 + type));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PageHeader ( ");
        sb.append("BlockIO ( ");
        sb.append(this.blockIo.getBlockId()).append(", ");
        if (this.blockIo.isDirty()) {
            sb.append("dirty, ");
        } else {
            sb.append("clean, ");
        }
        if (this.blockIo.isInTransaction()) {
            sb.append("in tx");
        } else {
            sb.append("no tx");
        }
        sb.append(" ), ");
        short magic = this.getMagic();
        switch (magic - 4945) {
            case 0: {
                sb.append("FREE_PAGE").append(", ");
                break;
            }
            case 1: {
                sb.append("USED_PAGE").append(", ");
                break;
            }
            case 2: {
                sb.append("TRANSLATION_PAGE").append(", ");
                break;
            }
            case 3: {
                sb.append("FREELOGIDS_PAGE").append(", ");
                break;
            }
            case 4: {
                sb.append("FREEPHYSIDS_PAGE").append(", ");
            }
        }
        sb.append("[p:").append(this.getPrev()).append(", ");
        sb.append("n:").append(this.getNext()).append("] )");
        return sb.toString();
    }
}

