/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import jdbm.helper.ActionVersioning;

public class ActionContext {
    boolean readOnly;
    ActionVersioning.Version version;
    String whoStarted;

    public void beginAction(boolean readOnly, ActionVersioning.Version version, String whoStarted) {
        this.readOnly = readOnly;
        this.version = version;
        this.whoStarted = whoStarted;
    }

    public void endAction() {
        assert (this.version != null) : "Unexpected action state during endAction: " + this;
        this.version = null;
    }

    public boolean isReadOnlyAction() {
        return this.readOnly && this.version != null;
    }

    public boolean isWriteAction() {
        return !this.readOnly && this.version != null;
    }

    public boolean isActive() {
        return this.version != null;
    }

    public ActionVersioning.Version getVersion() {
        return this.version;
    }

    public String getWhoStarted() {
        return this.whoStarted;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ActionContext: ");
        sb.append("(readOnly: ").append(this.readOnly);
        sb.append(", version: ").append(this.version);
        sb.append(", whoStarted: ").append(this.whoStarted);
        sb.append(")\n");
        return sb.toString();
    }
}

