/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleMatchFilter
extends Filter {
    private int expectedMatchingRuleLength;
    private String matchingRule;
    private byte[] matchingRuleBytes;
    private String type;
    private byte[] typeBytes;
    private Value<?> matchValue;
    private boolean dnAttributes = false;
    private int extensibleMatchLength;

    public ExtensibleMatchFilter(int tlvId) {
        super(tlvId);
    }

    public ExtensibleMatchFilter() {
    }

    public boolean isDnAttributes() {
        return this.dnAttributes;
    }

    public void setDnAttributes(boolean dnAttributes) {
        this.dnAttributes = dnAttributes;
    }

    public String getMatchingRule() {
        return this.matchingRule;
    }

    public void setMatchingRule(String matchingRule) {
        this.matchingRule = matchingRule;
    }

    public Value<?> getMatchValue() {
        return this.matchValue;
    }

    public void setMatchValue(Value<?> matchValue) {
        this.matchValue = matchValue;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getExpectedMatchingRuleLength() {
        return this.expectedMatchingRuleLength;
    }

    public void setExpectedMatchingRuleLength(int expectedMatchingRuleLength) {
        this.expectedMatchingRuleLength = expectedMatchingRuleLength;
    }

    @Override
    public int computeLength() {
        if (this.matchingRule != null) {
            this.matchingRuleBytes = Strings.getBytesUtf8(this.matchingRule);
            this.extensibleMatchLength = 1 + TLV.getNbBytes(this.matchingRuleBytes.length) + this.matchingRuleBytes.length;
        }
        if (this.type != null) {
            this.typeBytes = Strings.getBytesUtf8(this.type);
            this.extensibleMatchLength += 1 + TLV.getNbBytes(this.typeBytes.length) + this.typeBytes.length;
        }
        if (this.matchValue != null) {
            int bytesLength = this.matchValue.getBytes().length;
            this.extensibleMatchLength += 1 + TLV.getNbBytes(bytesLength) + bytesLength;
        }
        if (this.dnAttributes) {
            this.extensibleMatchLength += 3;
        }
        return 1 + TLV.getNbBytes(this.extensibleMatchLength) + this.extensibleMatchLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        try {
            buffer.put((byte)-87);
            buffer.put(TLV.getBytes(this.extensibleMatchLength));
            if (this.matchingRule == null && this.type == null) {
                throw new EncoderException(I18n.err(I18n.ERR_04056, new Object[0]));
            }
            if (this.matchingRule != null) {
                buffer.put((byte)-127);
                buffer.put(TLV.getBytes(this.matchingRuleBytes.length));
                buffer.put(this.matchingRuleBytes);
            }
            if (this.type != null) {
                buffer.put((byte)-126);
                buffer.put(TLV.getBytes(this.typeBytes.length));
                buffer.put(this.typeBytes);
            }
            if (this.matchValue != null) {
                buffer.put((byte)-125);
                byte[] bytes = this.matchValue.getBytes();
                int bytesLength = bytes.length;
                buffer.put(TLV.getBytes(bytesLength));
                if (bytesLength != 0) {
                    buffer.put(bytes);
                }
            }
            if (this.dnAttributes) {
                buffer.put((byte)-124);
                buffer.put((byte)1);
                buffer.put((byte)-1);
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.type != null) {
            sb.append(this.type);
        }
        if (this.dnAttributes) {
            sb.append(":dn");
        }
        if (this.matchingRule == null) {
            if (this.type == null) {
                return "Extended Filter wrong syntax";
            }
        } else {
            sb.append(':').append(this.matchingRule);
        }
        sb.append(":=").append(this.matchValue);
        return sb.toString();
    }
}

