/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.model.entry.Entry;

public class AllEntriesCursor<ID extends Comparable<ID>>
extends AbstractIndexCursor<ID, Entry, ID> {
    private IndexEntry<ID, Entry, ID> indexEntry = new ForwardIndexEntry<ID, Entry, ID>();
    private final IndexCursor<String, Entry, ID> wrapped;

    public AllEntriesCursor(Store<Entry, ID> db) throws Exception {
        this.wrapped = db.getEntryUuidIndex().reverseCursor();
    }

    @Override
    public void afterValue(ID key, ID value) throws Exception {
        this.checkNotClosed("afterValue()");
        this.wrapped.afterValue(key, null);
    }

    @Override
    public void beforeValue(ID id, ID value) throws Exception {
        this.checkNotClosed("beforeValue()");
        this.wrapped.beforeValue(id, null);
    }

    @Override
    public void after(IndexEntry<ID, Entry, ID> indexEntry) throws Exception {
        this.checkNotClosed("after()");
        this.wrapped.afterValue(indexEntry.getId(), null);
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
    }

    @Override
    public boolean available() {
        return this.wrapped.available();
    }

    @Override
    public void before(IndexEntry<ID, Entry, ID> indexEntry) throws Exception {
        this.checkNotClosed("before()");
        this.wrapped.beforeValue(indexEntry.getId(), null);
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.wrapped.beforeFirst();
    }

    @Override
    public boolean first() throws Exception {
        this.checkNotClosed("first()");
        return this.wrapped.first();
    }

    @Override
    public IndexEntry<ID, Entry, ID> get() throws Exception {
        this.checkNotClosed("get()");
        IndexEntry wrappedEntry = (IndexEntry)this.wrapped.get();
        this.indexEntry.setId(wrappedEntry.getId());
        this.indexEntry.setValue(wrappedEntry.getId());
        this.indexEntry.setObject((Entry)wrappedEntry.getObject());
        return this.indexEntry;
    }

    @Override
    public boolean last() throws Exception {
        this.checkNotClosed("last()");
        return this.wrapped.last();
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        return this.wrapped.next();
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        return this.wrapped.previous();
    }

    @Override
    public void close() throws Exception {
        this.wrapped.close();
        super.close();
    }

    @Override
    public void close(Exception cause) throws Exception {
        this.wrapped.close();
        super.close(cause);
    }
}

