/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.event.EventType;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.replication.ReplicaEventLog;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDn;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDnType;
import org.apache.directory.shared.ldap.extras.controls.SyncStateTypeEnum;
import org.apache.directory.shared.ldap.extras.controls.SyncStateValue;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnDecorator;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncStateValueDecorator;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.model.message.AbandonListener;
import org.apache.directory.shared.ldap.model.message.AbandonableRequest;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchResultEntry;
import org.apache.directory.shared.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.shared.ldap.model.message.controls.ChangeType;
import org.apache.directory.shared.util.Strings;
import org.apache.mina.core.future.WriteFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReplSearchListener
implements DirectoryListener,
AbandonListener {
    private static final Logger LOG = LoggerFactory.getLogger(SyncReplSearchListener.class);
    private LdapSession session;
    private SearchRequest searchRequest;
    private volatile boolean pushInRealTime;
    private final ReplicaEventLog consumerMsgLog;
    private DirectoryService directoryService;

    SyncReplSearchListener(LdapSession session, SearchRequest searchRequest, ReplicaEventLog consumerMsgLog, boolean pushInRealTime) {
        this.pushInRealTime = pushInRealTime;
        this.session = session;
        this.setSearchRequest(searchRequest);
        this.consumerMsgLog = consumerMsgLog;
        this.directoryService = session.getLdapServer().getDirectoryService();
    }

    public void setSession(LdapSession session) {
        this.session = session;
        this.directoryService = session.getLdapServer().getDirectoryService();
    }

    public void setSearchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        if (searchRequest != null) {
            searchRequest.addAbandonListener(this);
        }
    }

    @Override
    public void requestAbandoned(AbandonableRequest searchRequest) {
        try {
            if (this.session != null) {
                this.directoryService.getEventService().removeListener(this);
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_164, new Object[0]), e);
        }
    }

    private SyncStateValue createControl(DirectoryService directoryService, SyncStateTypeEnum operation, Entry entry) throws LdapInvalidAttributeValueException {
        SyncStateValueDecorator syncStateValue = new SyncStateValueDecorator(directoryService.getLdapCodecService());
        syncStateValue.setSyncStateType(operation);
        syncStateValue.setEntryUUID(Strings.uuidToBytes(entry.get("entryUUID").getString()));
        syncStateValue.setCookie(this.getCookie(entry));
        return syncStateValue;
    }

    private void sendResult(SearchResultEntry searchResultEntry, Entry entry, EventType eventType, SyncStateValue syncStateValue, SyncModifyDn syncModifyDn) {
        searchResultEntry.addControl(syncStateValue);
        LOG.debug("sending event {} of entry {}", (Object)eventType, (Object)entry.getDn());
        WriteFuture future = this.session.getIoSession().write(searchResultEntry);
        this.handleWriteFuture(future, entry, eventType, syncModifyDn);
    }

    @Override
    public void entryAdded(AddOperationContext addContext) {
        Entry entry = addContext.getEntry();
        try {
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.ADD, ((ClonedServerEntry)entry).getClonedEntry()));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(entry.getDn());
                resultEntry.setEntry(entry);
                SyncStateValue syncAdd = this.createControl(this.directoryService, SyncStateTypeEnum.ADD, entry);
                this.sendResult(resultEntry, entry, EventType.ADD, syncAdd, null);
            }
        }
        catch (LdapInvalidAttributeValueException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    @Override
    public void entryDeleted(DeleteOperationContext deleteContext) {
        Entry entry = deleteContext.getEntry();
        this.sendDeletedEntry(entry);
    }

    private void sendDeletedEntry(Entry entry) {
        try {
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.DELETE, entry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(entry.getDn());
                resultEntry.setEntry(entry);
                SyncStateValue syncDelete = this.createControl(this.directoryService, SyncStateTypeEnum.DELETE, entry);
                this.sendResult(resultEntry, entry, EventType.DELETE, syncDelete, null);
            }
        }
        catch (LdapInvalidAttributeValueException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    @Override
    public void entryModified(ModifyOperationContext modifyContext) {
        Entry alteredEntry = modifyContext.getAlteredEntry();
        try {
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.MODIFY, alteredEntry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(modifyContext.getDn());
                resultEntry.setEntry(alteredEntry);
                SyncStateValue syncModify = this.createControl(this.directoryService, SyncStateTypeEnum.MODIFY, alteredEntry);
                this.sendResult(resultEntry, alteredEntry, EventType.MODIFY, syncModify, null);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    @Override
    public void entryMoved(MoveOperationContext moveContext) {
        Entry entry = moveContext.getOriginalEntry();
        try {
            if (!moveContext.getNewSuperior().isDescendantOf(this.consumerMsgLog.getSearchCriteria().getBase())) {
                this.sendDeletedEntry(entry);
                return;
            }
            SyncModifyDnDecorator modDnControl = new SyncModifyDnDecorator(this.directoryService.getLdapCodecService(), SyncModifyDnType.MOVE);
            modDnControl.setEntryDn(moveContext.getDn().getNormName());
            modDnControl.setNewSuperiorDn(moveContext.getNewSuperior().getNormName());
            this.consumerMsgLog.log(new ReplicaEventMessage(modDnControl, entry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(moveContext.getDn());
                resultEntry.setEntry(entry);
                resultEntry.addControl(modDnControl);
                SyncStateValue syncModify = this.createControl(this.directoryService, SyncStateTypeEnum.MODDN, entry);
                this.sendResult(resultEntry, entry, null, syncModify, modDnControl);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    @Override
    public void entryMovedAndRenamed(MoveAndRenameOperationContext moveAndRenameContext) {
        try {
            if (!moveAndRenameContext.getNewSuperiorDn().isDescendantOf(this.consumerMsgLog.getSearchCriteria().getBase())) {
                this.sendDeletedEntry(moveAndRenameContext.getEntry());
                return;
            }
            SyncModifyDnDecorator modDnControl = new SyncModifyDnDecorator(this.directoryService.getLdapCodecService(), SyncModifyDnType.MOVE_AND_RENAME);
            modDnControl.setEntryDn(moveAndRenameContext.getDn().getNormName());
            modDnControl.setNewSuperiorDn(moveAndRenameContext.getNewSuperiorDn().getNormName());
            modDnControl.setNewRdn(moveAndRenameContext.getNewRdn().getNormName());
            modDnControl.setDeleteOldRdn(moveAndRenameContext.getDeleteOldRdn());
            Entry entry = moveAndRenameContext.getOriginalEntry();
            this.consumerMsgLog.log(new ReplicaEventMessage(modDnControl, entry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(entry.getDn());
                resultEntry.setEntry(entry);
                resultEntry.addControl(modDnControl);
                SyncStateValue syncModify = this.createControl(this.directoryService, SyncStateTypeEnum.MODDN, entry);
                this.sendResult(resultEntry, entry, null, syncModify, modDnControl);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    @Override
    public void entryRenamed(RenameOperationContext renameContext) {
        Entry entry = renameContext.getOriginalEntry();
        try {
            SyncModifyDnDecorator modDnControl = new SyncModifyDnDecorator(this.directoryService.getLdapCodecService());
            modDnControl.setModDnType(SyncModifyDnType.RENAME);
            modDnControl.setEntryDn(renameContext.getDn().getName());
            modDnControl.setNewRdn(renameContext.getNewRdn().getName());
            modDnControl.setDeleteOldRdn(renameContext.getDeleteOldRdn());
            this.consumerMsgLog.log(new ReplicaEventMessage(modDnControl, entry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(entry.getDn());
                resultEntry.setEntry(entry);
                resultEntry.addControl(modDnControl);
                SyncStateValue syncModify = this.createControl(this.directoryService, SyncStateTypeEnum.MODDN, entry);
                syncModify.setCookie(this.getCookie(entry));
                this.sendResult(resultEntry, entry, null, syncModify, modDnControl);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public boolean isPushInRealTime() {
        return this.pushInRealTime;
    }

    public void setPushInRealTime(boolean pushInRealTime) {
        this.pushInRealTime = pushInRealTime;
    }

    private byte[] getCookie(Entry entry) throws LdapInvalidAttributeValueException {
        String csn = entry.get("entryCSN").getString();
        return Strings.getBytesUtf8(this.consumerMsgLog.getId() + ";" + csn);
    }

    private void handleWriteFuture(WriteFuture future, Entry entry, EventType event, SyncModifyDn modDnControl) {
        future.awaitUninterruptibly(10000L);
        if (!future.isWritten()) {
            LOG.error("Failed to write to the consumer {} during the event {} on entry {}", new Object[]{this.consumerMsgLog.getId(), event, entry.getDn()});
            LOG.error("", future.getException());
            this.pushInRealTime = false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SyncReplSearchListener : \n");
        sb.append('\'').append(this.searchRequest).append("', ");
        sb.append('\'').append(this.pushInRealTime).append("', \n");
        sb.append(this.consumerMsgLog);
        sb.append('\n');
        return sb.toString();
    }
}

