/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.ConfigurationException;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.interceptor.InterceptorException;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchObjectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptorChain {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private final Interceptor FINAL_INTERCEPTOR = new Interceptor(){
        private PartitionNexus nexus;

        @Override
        public String getName() {
            return "FINAL";
        }

        @Override
        public void init(DirectoryService directoryService) {
            this.nexus = directoryService.getPartitionNexus();
        }

        @Override
        public void destroy() {
        }

        @Override
        public boolean compare(NextInterceptor next, CompareOperationContext compareContext) throws LdapException {
            return this.nexus.compare(compareContext);
        }

        @Override
        public Entry getRootDSE(NextInterceptor next, GetRootDSEOperationContext getRootDseContext) throws LdapException {
            return this.nexus.getRootDSE(getRootDseContext);
        }

        @Override
        public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws LdapException {
            this.nexus.delete(deleteContext);
        }

        @Override
        public void add(NextInterceptor next, AddOperationContext addContext) throws LdapException {
            this.nexus.add(addContext);
        }

        @Override
        public void modify(NextInterceptor next, ModifyOperationContext modifyContext) throws LdapException {
            this.nexus.modify(modifyContext);
        }

        @Override
        public EntryFilteringCursor list(NextInterceptor next, ListOperationContext listContext) throws LdapException {
            return this.nexus.list(listContext);
        }

        @Override
        public EntryFilteringCursor search(NextInterceptor next, SearchOperationContext searchContext) throws LdapException {
            return this.nexus.search(searchContext);
        }

        @Override
        public Entry lookup(NextInterceptor next, LookupOperationContext lookupContext) throws LdapException {
            return this.nexus.lookup(lookupContext);
        }

        @Override
        public boolean hasEntry(NextInterceptor next, EntryOperationContext hasEntryContext) throws LdapException {
            return this.nexus.hasEntry(hasEntryContext);
        }

        @Override
        public void rename(NextInterceptor next, RenameOperationContext renameContext) throws LdapException {
            this.nexus.rename(renameContext);
        }

        @Override
        public void move(NextInterceptor next, MoveOperationContext moveContext) throws LdapException {
            this.nexus.move(moveContext);
        }

        @Override
        public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
            this.nexus.moveAndRename(moveAndRenameContext);
        }

        @Override
        public void bind(NextInterceptor next, BindOperationContext bindContext) throws LdapException {
            this.nexus.bind(bindContext);
        }

        @Override
        public void unbind(NextInterceptor next, UnbindOperationContext unbindContext) throws LdapException {
            this.nexus.unbind(unbindContext);
        }
    };
    private final Map<String, Element> name2entry = new HashMap<String, Element>();
    private final Element tail;
    private Element head = this.tail = new Element("tail", null, null, this.FINAL_INTERCEPTOR);
    private DirectoryService directoryService;

    public synchronized void init(DirectoryService directoryService) throws LdapException {
        this.directoryService = directoryService;
        this.FINAL_INTERCEPTOR.init(directoryService);
        try {
            for (Interceptor interceptor : directoryService.getInterceptors()) {
                if (IS_DEBUG) {
                    LOG.debug("Adding interceptor " + interceptor.getName());
                }
                this.register(interceptor);
            }
        }
        catch (Throwable t) {
            this.destroy();
            if (t instanceof LdapException) {
                throw (LdapException)t;
            }
            throw new InterceptorException(null, I18n.err(I18n.ERR_329, new Object[0]), t);
        }
    }

    public synchronized void destroy() {
        ArrayList<Element> entries = new ArrayList<Element>();
        Element e = this.tail;
        do {
            entries.add(e);
        } while ((e = e.prevEntry) != null);
        for (Element entry : entries) {
            if (entry == this.tail) continue;
            try {
                this.deregister(entry.getName());
            }
            catch (Throwable t) {
                LOG.warn("Failed to deregister an interceptor: " + entry.getName(), t);
            }
        }
    }

    public Interceptor get(String interceptorName) {
        Element e = this.name2entry.get(interceptorName);
        if (e == null) {
            return null;
        }
        return e.interceptor;
    }

    public synchronized List<Interceptor> getAll() {
        ArrayList<Interceptor> result = new ArrayList<Interceptor>();
        Element e = this.head;
        do {
            result.add(e.interceptor);
        } while ((e = e.nextEntry) != this.tail);
        return result;
    }

    public synchronized void addFirst(Interceptor interceptor) throws Exception {
        this.register0(interceptor, this.head);
    }

    public synchronized void addLast(Interceptor interceptor) throws Exception {
        this.register0(interceptor, this.tail);
    }

    public synchronized void addBefore(String nextInterceptorName, Interceptor interceptor) throws Exception {
        Element e = this.name2entry.get(nextInterceptorName);
        if (e == null) {
            throw new ConfigurationException(I18n.err(I18n.ERR_330, nextInterceptorName));
        }
        this.register0(interceptor, e);
    }

    public synchronized String remove(String interceptorName) throws Exception {
        return this.deregister(interceptorName);
    }

    public synchronized void addAfter(String prevInterceptorName, Interceptor interceptor) throws Exception {
        Element e = this.name2entry.get(prevInterceptorName);
        if (e == null) {
            throw new ConfigurationException(I18n.err(I18n.ERR_330, prevInterceptorName));
        }
        this.register0(interceptor, e.nextEntry);
    }

    private void register(Interceptor interceptor) throws Exception {
        this.checkAddable(interceptor);
        this.register0(interceptor, this.tail);
    }

    private String deregister(String name) throws ConfigurationException {
        Element entry = this.checkOldName(name);
        Element prevEntry = entry.prevEntry;
        Element nextEntry = entry.nextEntry;
        if (nextEntry == null) {
            return null;
        }
        if (prevEntry == null) {
            nextEntry.prevEntry = null;
            this.head = nextEntry;
        } else {
            prevEntry.nextEntry = nextEntry;
            nextEntry.prevEntry = prevEntry;
        }
        this.name2entry.remove(name);
        entry.interceptor.destroy();
        return entry.getName();
    }

    private void register0(Interceptor interceptor, Element nextEntry) throws Exception {
        Element newEntry;
        String name = interceptor.getName();
        interceptor.init(this.directoryService);
        if (nextEntry == this.head) {
            newEntry = new Element(interceptor.getName(), null, this.head, interceptor);
            this.head.prevEntry = newEntry;
            this.head = newEntry;
        } else if (this.head == this.tail) {
            newEntry = new Element(interceptor.getName(), null, this.tail, interceptor);
            this.tail.prevEntry = newEntry;
            this.head = newEntry;
        } else {
            newEntry = new Element(interceptor.getName(), nextEntry.prevEntry, nextEntry, interceptor);
            nextEntry.prevEntry.nextEntry = newEntry;
            nextEntry.prevEntry = newEntry;
        }
        this.name2entry.put(name, newEntry);
    }

    private Element checkOldName(String name) throws ConfigurationException {
        Element e = this.name2entry.get(name);
        if (e == null) {
            throw new ConfigurationException(I18n.err(I18n.ERR_331, name));
        }
        return e;
    }

    private void checkAddable(Interceptor interceptor) throws ConfigurationException {
        if (this.name2entry.containsKey(interceptor.getName())) {
            throw new ConfigurationException(I18n.err(I18n.ERR_332, interceptor.getName()));
        }
    }

    private Element getStartingEntry() {
        if (InvocationStack.getInstance().isEmpty()) {
            return this.head;
        }
        OperationContext opContext = InvocationStack.getInstance().peek();
        if (!opContext.hasBypass()) {
            return this.head;
        }
        if (opContext.isBypassed("*")) {
            return this.tail;
        }
        Element next = this.head;
        while (next != this.tail) {
            if (opContext.isBypassed(next.getName())) {
                next = next.nextEntry;
                continue;
            }
            return next;
        }
        return this.tail;
    }

    public Entry getRootDSE(GetRootDSEOperationContext getRootDseContext) throws LdapException {
        Element entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.getRootDSE(next, getRootDseContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        Element entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        compareContext.setOriginalEntry(this.getOriginalEntry(compareContext));
        try {
            return head.compare(next, compareContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    private void eagerlyPopulateFields(OperationContext opContext) throws LdapException {
        if (opContext.getEntry() == null) {
            CoreSession adminSession = opContext.getSession().getDirectoryService().getAdminSession();
            LookupOperationContext lookupContext = new LookupOperationContext(adminSession, opContext.getDn(), SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            Entry foundEntry = opContext.getSession().getDirectoryService().getPartitionNexus().lookup(lookupContext);
            if (foundEntry != null) {
                opContext.setEntry(foundEntry);
            } else {
                LdapNoSuchObjectException ldnfe = new LdapNoSuchObjectException(I18n.err(I18n.ERR_256_NO_SUCH_OBJECT, opContext.getDn()));
                throw ldnfe;
            }
        }
    }

    private Entry getOriginalEntry(OperationContext opContext) throws LdapException {
        CoreSession adminSession = opContext.getSession().getDirectoryService().getAdminSession();
        Entry foundEntry = adminSession.lookup(opContext.getDn(), "+", "*");
        if (foundEntry != null) {
            return foundEntry;
        }
        LdapNoSuchObjectException ldnfe = new LdapNoSuchObjectException(I18n.err(I18n.ERR_256_NO_SUCH_OBJECT, opContext.getDn()));
        throw ldnfe;
    }

    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        Element entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        this.eagerlyPopulateFields(deleteContext);
        try {
            head.delete(next, deleteContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void add(AddOperationContext addContext) throws LdapException {
        Element node = this.getStartingEntry();
        Interceptor head = node.interceptor;
        NextInterceptor next = node.nextInterceptor;
        try {
            head.add(next, addContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void bind(BindOperationContext bindContext) throws LdapException {
        Element node = this.getStartingEntry();
        Interceptor head = node.interceptor;
        NextInterceptor next = node.nextInterceptor;
        try {
            head.bind(next, bindContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void unbind(UnbindOperationContext unbindContext) throws LdapException {
        Element node = this.getStartingEntry();
        Interceptor head = node.interceptor;
        NextInterceptor next = node.nextInterceptor;
        try {
            head.unbind(next, unbindContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        Element entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        this.eagerlyPopulateFields(modifyContext);
        try {
            head.modify(next, modifyContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public EntryFilteringCursor list(ListOperationContext listContext) throws LdapException {
        Element entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.list(next, listContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        Element entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.search(next, searchContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        Element entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.lookup(next, lookupContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public boolean hasEntry(EntryOperationContext hasEntryContext) throws LdapException {
        Element entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.hasEntry(next, hasEntryContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public void rename(RenameOperationContext renameContext) throws LdapException {
        Element entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        this.eagerlyPopulateFields(renameContext);
        Entry originalEntry = this.getOriginalEntry(renameContext);
        renameContext.setOriginalEntry(originalEntry);
        renameContext.setModifiedEntry(originalEntry.clone());
        try {
            head.rename(next, renameContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        Element entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        Entry originalEntry = this.getOriginalEntry(moveContext);
        moveContext.setOriginalEntry(originalEntry);
        try {
            head.move(next, moveContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Element entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        moveAndRenameContext.setOriginalEntry(this.getOriginalEntry(moveAndRenameContext));
        moveAndRenameContext.setModifiedEntry(moveAndRenameContext.getOriginalEntry().clone());
        try {
            head.moveAndRename(next, moveAndRenameContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    private static void throwInterceptorException(Interceptor interceptor, Throwable e) throws InterceptorException {
        throw new InterceptorException(interceptor, I18n.err(I18n.ERR_333, new Object[0]), e);
    }

    private class Element {
        private volatile Element prevEntry;
        private volatile Element nextEntry;
        private final String name;
        private final Interceptor interceptor;
        private final NextInterceptor nextInterceptor;

        private String getName() {
            return this.name;
        }

        private Element(String name, Element prevEntry, Element nextEntry, Interceptor interceptor) {
            this.name = name;
            if (interceptor == null) {
                throw new IllegalArgumentException("interceptor");
            }
            this.prevEntry = prevEntry;
            this.nextEntry = nextEntry;
            this.interceptor = interceptor;
            this.nextInterceptor = new NextInterceptor(){

                private Element getNextEntry() {
                    if (InvocationStack.getInstance().isEmpty()) {
                        return Element.this.nextEntry;
                    }
                    OperationContext opContext = InvocationStack.getInstance().peek();
                    if (!opContext.hasBypass()) {
                        return Element.this.nextEntry;
                    }
                    Element next = Element.this.nextEntry;
                    while (next != InterceptorChain.this.tail) {
                        if (opContext.isBypassed(next.getName())) {
                            next = next.nextEntry;
                            continue;
                        }
                        return next;
                    }
                    return next;
                }

                @Override
                public boolean compare(CompareOperationContext compareContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        boolean result = interceptor.compare(next.nextInterceptor, compareContext);
                        return result;
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public Entry getRootDSE(GetRootDSEOperationContext getRootDseContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        Entry rootDSE = interceptor.getRootDSE(next.nextInterceptor, getRootDseContext);
                        return rootDSE;
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public void delete(DeleteOperationContext deleteContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.delete(next.nextInterceptor, deleteContext);
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void add(AddOperationContext addContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.add(next.nextInterceptor, addContext);
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void modify(ModifyOperationContext modifyContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.modify(next.nextInterceptor, modifyContext);
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public EntryFilteringCursor list(ListOperationContext listContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        EntryFilteringCursor cursor = interceptor.list(next.nextInterceptor, listContext);
                        return cursor;
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        EntryFilteringCursor cursor = interceptor.search(next.nextInterceptor, searchContext);
                        return cursor;
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        Entry entry = interceptor.lookup(next.nextInterceptor, lookupContext);
                        return entry;
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public boolean hasEntry(EntryOperationContext hasEntryContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        boolean hasEntry = interceptor.hasEntry(next.nextInterceptor, hasEntryContext);
                        return hasEntry;
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public void rename(RenameOperationContext renameContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.rename(next.nextInterceptor, renameContext);
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void move(MoveOperationContext moveContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.move(next.nextInterceptor, moveContext);
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.moveAndRename(next.nextInterceptor, moveAndRenameContext);
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void bind(BindOperationContext bindContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.bind(next.nextInterceptor, bindContext);
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void unbind(UnbindOperationContext unbindContext) throws LdapException {
                    Element next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.unbind(next.nextInterceptor, unbindContext);
                    }
                    catch (LdapException le) {
                        throw le;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }
            };
        }
    }
}

