/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapPrincipalSerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(LdapPrincipalSerializer.class);

    private LdapPrincipalSerializer() {
    }

    public static void serialize(LdapPrincipal principal, ObjectOutput out) throws IOException {
        out.writeInt(principal.getAuthenticationLevel().getLevel());
        if (principal.getDn() == null) {
            Dn.EMPTY_DN.writeExternal(out);
        } else {
            principal.getDn().writeExternal(out);
        }
    }

    public static LdapPrincipal deserialize(SchemaManager schemaManager, ObjectInput in) throws IOException, LdapInvalidDnException {
        AuthenticationLevel authenticationLevel = AuthenticationLevel.getLevel(in.readInt());
        Dn dn = new Dn(schemaManager);
        try {
            dn.readExternal(in);
        }
        catch (ClassNotFoundException cnfe) {
            IOException ioe = new IOException(cnfe.getMessage());
            ioe.initCause(cnfe);
            throw ioe;
        }
        LdapPrincipal principal = new LdapPrincipal(schemaManager, dn, authenticationLevel);
        return principal;
    }
}

