/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import jdbm.recman.BlockIo;
import jdbm.recman.TransactionManager;
import org.apache.directory.server.i18n.I18n;

public final class RecordFile {
    private TransactionManager transactionManager;
    private final LinkedList<BlockIo> free = new LinkedList();
    private final HashMap<Long, BlockIo> inUse = new HashMap();
    private final HashMap<Long, BlockIo> dirty = new HashMap();
    private final HashMap<Long, BlockIo> inTxn = new HashMap();
    private boolean transactionsDisabled = false;
    public static final int BLOCK_SIZE = 8192;
    static final String extension = ".db";
    static final byte[] cleanData = new byte[8192];
    private RandomAccessFile file;
    private final String fileName;

    RecordFile(String fileName) throws IOException {
        this.fileName = fileName;
        this.file = new RandomAccessFile(fileName + extension, "rw");
    }

    TransactionManager getTxnMgr() throws IOException {
        if (this.transactionsDisabled) {
            throw new IllegalStateException("Transactions are disabled.");
        }
        if (this.transactionManager == null) {
            this.transactionManager = new TransactionManager(this);
        }
        return this.transactionManager;
    }

    String getFileName() {
        return this.fileName;
    }

    void disableTransactions() {
        this.transactionsDisabled = true;
    }

    BlockIo get(long blockid) throws IOException {
        BlockIo node = this.inTxn.get(blockid);
        if (node != null) {
            this.inTxn.remove(blockid);
            this.inUse.put(blockid, node);
            return node;
        }
        node = this.dirty.get(blockid);
        if (node != null) {
            this.dirty.remove(blockid);
            this.inUse.put(blockid, node);
            return node;
        }
        Iterator i = this.free.iterator();
        while (i.hasNext()) {
            BlockIo cur = (BlockIo)i.next();
            if (cur.getBlockId() != blockid) continue;
            node = cur;
            i.remove();
            this.inUse.put(blockid, node);
            return node;
        }
        if (this.inUse.get(blockid) != null) {
            throw new Error(I18n.err(I18n.ERR_554, blockid));
        }
        node = this.getNewNode(blockid);
        long offset = blockid * 8192L;
        if (this.file.length() > 0L && offset <= this.file.length()) {
            RecordFile.read(this.file, offset, node.getData(), 8192);
        } else {
            System.arraycopy(cleanData, 0, node.getData(), 0, 8192);
        }
        this.inUse.put(blockid, node);
        node.setClean();
        return node;
    }

    void release(long blockid, boolean isDirty) throws IOException {
        BlockIo node = this.inUse.get(blockid);
        if (node == null) {
            throw new IOException(I18n.err(I18n.ERR_555, blockid));
        }
        if (!node.isDirty() && isDirty) {
            node.setDirty();
        }
        this.release(node);
    }

    void release(BlockIo block) {
        this.inUse.remove(block.getBlockId());
        if (block.isDirty()) {
            this.dirty.put(block.getBlockId(), block);
        } else if (!this.transactionsDisabled && block.isInTransaction()) {
            this.inTxn.put(block.getBlockId(), block);
        } else {
            this.free.add(block);
        }
    }

    void discard(BlockIo block) {
        this.inUse.remove(block.getBlockId());
    }

    void commit() throws IOException {
        if (!this.inUse.isEmpty() && this.inUse.size() > 1) {
            this.showList(this.inUse.values().iterator());
            throw new Error(I18n.err(I18n.ERR_556, this.inUse.size()));
        }
        if (this.dirty.size() == 0) {
            return;
        }
        if (!this.transactionsDisabled) {
            this.getTxnMgr().start();
        }
        Iterator<BlockIo> i = this.dirty.values().iterator();
        while (i.hasNext()) {
            BlockIo node = i.next();
            i.remove();
            if (this.transactionsDisabled) {
                long offset = node.getBlockId() * 8192L;
                this.file.seek(offset);
                this.file.write(node.getData());
                node.setClean();
                this.free.add(node);
                continue;
            }
            this.getTxnMgr().add(node);
            this.inTxn.put(node.getBlockId(), node);
        }
        if (!this.transactionsDisabled) {
            this.getTxnMgr().commit();
        }
    }

    void rollback() throws IOException {
        if (!this.inUse.isEmpty()) {
            this.showList(this.inUse.values().iterator());
            throw new Error(I18n.err(I18n.ERR_557, this.inUse.size()));
        }
        this.dirty.clear();
        if (!this.transactionsDisabled) {
            this.getTxnMgr().synchronizeLogFromDisk();
        }
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.values().iterator());
            throw new Error(I18n.err(I18n.ERR_558, this.inTxn.size()));
        }
    }

    void close() throws IOException {
        if (!this.dirty.isEmpty()) {
            this.commit();
        }
        if (!this.transactionsDisabled) {
            this.getTxnMgr().shutdown();
        }
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.values().iterator());
            throw new Error(I18n.err(I18n.ERR_559, new Object[0]));
        }
        if (!this.dirty.isEmpty()) {
            System.out.println("ERROR: dirty blocks at close time");
            this.showList(this.dirty.values().iterator());
            throw new Error(I18n.err(I18n.ERR_560, new Object[0]));
        }
        if (!this.inUse.isEmpty()) {
            System.out.println("ERROR: inUse blocks at close time");
            this.showList(this.inUse.values().iterator());
            throw new Error(I18n.err(I18n.ERR_561, new Object[0]));
        }
        this.file.close();
        this.file = null;
    }

    void forceClose() throws IOException {
        if (!this.transactionsDisabled) {
            this.getTxnMgr().forceClose();
        }
        this.file.close();
    }

    private void showList(Iterator<BlockIo> i) {
        int cnt = 0;
        while (i.hasNext()) {
            System.out.println("elem " + cnt + ": " + i.next());
            ++cnt;
        }
    }

    private BlockIo getNewNode(long blockid) throws IOException {
        BlockIo retval = null;
        if (!this.free.isEmpty()) {
            retval = this.free.removeFirst();
        }
        if (retval == null) {
            retval = new BlockIo(0L, new byte[8192]);
        }
        retval.setBlockId(blockid);
        retval.setView(null);
        return retval;
    }

    void synch(BlockIo node) throws IOException {
        byte[] data = node.getData();
        if (data != null) {
            long offset = node.getBlockId() * 8192L;
            this.file.seek(offset);
            this.file.write(data);
        }
    }

    void releaseFromTransaction(BlockIo node, boolean recycle) throws IOException {
        if (this.inTxn.remove(node.getBlockId()) != null && recycle) {
            this.free.add(node);
        }
    }

    void sync() throws IOException {
        this.file.getFD().sync();
    }

    private static void read(RandomAccessFile file, long offset, byte[] buffer, int nBytes) throws IOException {
        file.seek(offset);
        int remaining = nBytes;
        int pos = 0;
        while (remaining > 0) {
            int read = file.read(buffer, pos, remaining);
            if (read == -1) {
                System.arraycopy(cleanData, 0, buffer, pos, remaining);
                break;
            }
            remaining -= read;
            pos += read;
        }
    }
}

