/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.osgi;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.ldap.codec.BasicControlDecorator;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.controls.cascade.CascadeFactory;
import org.apache.directory.api.ldap.codec.controls.manageDsaIT.ManageDsaITFactory;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeFactory;
import org.apache.directory.api.ldap.codec.controls.search.pagedSearch.PagedResultsFactory;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory;
import org.apache.directory.api.ldap.codec.controls.search.subentries.SubentriesFactory;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ExtendedRequestImpl;
import org.apache.directory.api.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.api.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.NotImplementedException;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapCodecService
implements LdapApiService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLdapCodecService.class);
    protected Map<String, ControlFactory<? extends Control>> controlFactories = new HashMap<String, ControlFactory<? extends Control>>();
    protected Map<String, ExtendedOperationFactory> extendedOperationsFactories = new HashMap<String, ExtendedOperationFactory>();
    protected ProtocolCodecFactory protocolCodecFactory;

    public DefaultLdapCodecService() {
        this.loadStockControls();
    }

    private void loadStockControls() {
        CascadeFactory cascadeFactory = new CascadeFactory(this);
        this.controlFactories.put(cascadeFactory.getOid(), cascadeFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)cascadeFactory.getOid());
        EntryChangeFactory entryChangeFactory = new EntryChangeFactory(this);
        this.controlFactories.put(entryChangeFactory.getOid(), entryChangeFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)entryChangeFactory.getOid());
        ManageDsaITFactory manageDsaItFactory = new ManageDsaITFactory(this);
        this.controlFactories.put(manageDsaItFactory.getOid(), manageDsaItFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)manageDsaItFactory.getOid());
        PagedResultsFactory pageResultsFactory = new PagedResultsFactory(this);
        this.controlFactories.put(pageResultsFactory.getOid(), pageResultsFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)pageResultsFactory.getOid());
        PersistentSearchFactory persistentSearchFactory = new PersistentSearchFactory(this);
        this.controlFactories.put(persistentSearchFactory.getOid(), persistentSearchFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)persistentSearchFactory.getOid());
        SubentriesFactory subentriesFactory = new SubentriesFactory(this);
        this.controlFactories.put(subentriesFactory.getOid(), subentriesFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)subentriesFactory.getOid());
    }

    @Override
    public ControlFactory<?> registerControl(ControlFactory<?> factory) {
        return this.controlFactories.put(factory.getOid(), factory);
    }

    @Override
    public ControlFactory<?> unregisterControl(String oid) {
        return this.controlFactories.remove(oid);
    }

    @Override
    public Iterator<String> registeredControls() {
        return Collections.unmodifiableSet(this.controlFactories.keySet()).iterator();
    }

    @Override
    public boolean isControlRegistered(String oid) {
        return this.controlFactories.containsKey(oid);
    }

    @Override
    public Iterator<String> registeredExtendedRequests() {
        return Collections.unmodifiableSet(this.extendedOperationsFactories.keySet()).iterator();
    }

    @Override
    public ExtendedOperationFactory registerExtendedRequest(ExtendedOperationFactory factory) {
        return this.extendedOperationsFactories.put(factory.getOid(), factory);
    }

    @Override
    public ProtocolCodecFactory getProtocolCodecFactory() {
        return this.protocolCodecFactory;
    }

    @Override
    public ProtocolCodecFactory registerProtocolCodecFactory(ProtocolCodecFactory protocolCodecFactory) {
        ProtocolCodecFactory oldFactory = this.protocolCodecFactory;
        this.protocolCodecFactory = protocolCodecFactory;
        return oldFactory;
    }

    @Override
    public CodecControl<? extends Control> newControl(String oid) {
        ControlFactory<? extends Control> factory = this.controlFactories.get(oid);
        if (factory == null) {
            return new BasicControlDecorator((LdapApiService)this, new OpaqueControl(oid));
        }
        return factory.newCodecControl();
    }

    @Override
    public CodecControl<? extends Control> newControl(Control control) {
        if (control == null) {
            throw new NullPointerException("Control argument was null.");
        }
        if (control instanceof CodecControl) {
            return (CodecControl)control;
        }
        ControlFactory<? extends Control> factory = this.controlFactories.get(control.getOid());
        if (factory == null) {
            return new BasicControlDecorator((LdapApiService)this, control);
        }
        return factory.newCodecControl(control);
    }

    @Override
    public javax.naming.ldap.Control toJndiControl(Control control) throws EncoderException {
        CodecControl<? extends Control> decorator = this.newControl(control);
        ByteBuffer bb = ByteBuffer.allocate(decorator.computeLength());
        decorator.encode(bb);
        bb.flip();
        BasicControl jndiControl = new BasicControl(control.getOid(), control.isCritical(), bb.array());
        return jndiControl;
    }

    @Override
    public Control fromJndiControl(javax.naming.ldap.Control control) throws DecoderException {
        ControlFactory<? extends Control> factory = this.controlFactories.get(control.getID());
        if (factory == null) {
            OpaqueControl ourControl = new OpaqueControl(control.getID());
            ourControl.setCritical(control.isCritical());
            BasicControlDecorator decorator = new BasicControlDecorator((LdapApiService)this, ourControl);
            decorator.setValue(control.getEncodedValue());
            return decorator;
        }
        CodecControl<? extends Control> ourControl = factory.newCodecControl();
        ourControl.setCritical(control.isCritical());
        ourControl.setValue(control.getEncodedValue());
        ourControl.decode(control.getEncodedValue());
        return ourControl;
    }

    @Override
    public Asn1Container newMessageContainer() {
        return new LdapMessageContainer(this);
    }

    @Override
    public ExtendedOperationFactory unregisterExtendedRequest(String oid) {
        return this.extendedOperationsFactories.remove(oid);
    }

    @Override
    public ExtendedResponse toJndi(org.apache.directory.api.ldap.model.message.ExtendedResponse modelResponse) throws EncoderException {
        throw new NotImplementedException("Figure out how to transform");
    }

    @Override
    public org.apache.directory.api.ldap.model.message.ExtendedResponse fromJndi(ExtendedResponse jndiResponse) throws DecoderException {
        throw new NotImplementedException("Figure out how to transform");
    }

    @Override
    public org.apache.directory.api.ldap.model.message.ExtendedRequest fromJndi(ExtendedRequest jndiRequest) throws DecoderException {
        ExtendedRequestDecorator decorator = (ExtendedRequestDecorator)this.newExtendedRequest(jndiRequest.getID(), jndiRequest.getEncodedValue());
        return decorator;
    }

    @Override
    public ExtendedRequest toJndi(final org.apache.directory.api.ldap.model.message.ExtendedRequest modelRequest) throws EncoderException {
        byte[] value;
        final String oid = modelRequest.getRequestName();
        if (modelRequest instanceof ExtendedRequestDecorator) {
            ExtendedRequestDecorator decorator = (ExtendedRequestDecorator)modelRequest;
            value = decorator.getRequestValue();
        } else {
            ExtendedOperationFactory extendedRequestFactory = this.extendedOperationsFactories.get(modelRequest.getRequestName());
            ExtendedRequestDecorator decorator = (ExtendedRequestDecorator)extendedRequestFactory.decorate(modelRequest);
            value = decorator.getRequestValue();
        }
        ExtendedRequest jndiRequest = new ExtendedRequest(){
            private static final long serialVersionUID = -4160980385909987475L;

            @Override
            public String getID() {
                return oid;
            }

            @Override
            public byte[] getEncodedValue() {
                return value;
            }

            @Override
            public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
                ExtendedOperationFactory factory = DefaultLdapCodecService.this.extendedOperationsFactories.get(modelRequest.getRequestName());
                try {
                    final ExtendedResponseDecorator resp = (ExtendedResponseDecorator)factory.newResponse(berValue);
                    ExtendedResponse jndiResponse = new ExtendedResponse(){
                        private static final long serialVersionUID = -7686354122066100703L;

                        @Override
                        public String getID() {
                            return oid;
                        }

                        @Override
                        public byte[] getEncodedValue() {
                            return resp.getResponseValue();
                        }
                    };
                    return jndiResponse;
                }
                catch (DecoderException e) {
                    NamingException ne = new NamingException("Unable to decode encoded response value: " + Strings.dumpBytes(berValue));
                    ne.setRootCause(e);
                    throw ne;
                }
            }
        };
        return jndiRequest;
    }

    @Override
    public <E extends org.apache.directory.api.ldap.model.message.ExtendedResponse> E newExtendedResponse(String responseName, int messageId, byte[] serializedResponse) throws DecoderException {
        ExtendedResponseDecorator<ExtendedResponseImpl> resp;
        ExtendedOperationFactory extendedRequestFactory = this.extendedOperationsFactories.get(responseName);
        if (extendedRequestFactory != null) {
            resp = (ExtendedResponseDecorator<ExtendedResponseImpl>)extendedRequestFactory.newResponse(serializedResponse);
        } else {
            resp = new ExtendedResponseDecorator<ExtendedResponseImpl>((LdapApiService)this, new ExtendedResponseImpl(responseName));
            resp.setResponseValue(serializedResponse);
            resp.setResponseName(responseName);
        }
        resp.setMessageId(messageId);
        return (E)resp;
    }

    @Override
    public org.apache.directory.api.ldap.model.message.ExtendedRequest newExtendedRequest(String oid, byte[] value) {
        ExtendedRequestDecorator<ExtendedRequestImpl> req = null;
        ExtendedOperationFactory extendedRequestFactory = this.extendedOperationsFactories.get(oid);
        if (extendedRequestFactory != null) {
            req = extendedRequestFactory.newRequest(value);
        } else {
            ExtendedRequestDecorator<ExtendedRequestImpl> decorator = new ExtendedRequestDecorator<ExtendedRequestImpl>((LdapApiService)this, new ExtendedRequestImpl());
            decorator.setRequestName(oid);
            decorator.setRequestValue(value);
            req = decorator;
        }
        return req;
    }

    @Override
    public ExtendedRequestDecorator<?> decorate(org.apache.directory.api.ldap.model.message.ExtendedRequest decoratedMessage) {
        ExtendedRequestDecorator<org.apache.directory.api.ldap.model.message.ExtendedRequest> req = null;
        ExtendedOperationFactory extendedRequestFactory = this.extendedOperationsFactories.get(decoratedMessage.getRequestName());
        req = extendedRequestFactory != null ? (ExtendedRequestDecorator<org.apache.directory.api.ldap.model.message.ExtendedRequest>)extendedRequestFactory.decorate(decoratedMessage) : new ExtendedRequestDecorator<org.apache.directory.api.ldap.model.message.ExtendedRequest>((LdapApiService)this, decoratedMessage);
        return req;
    }

    @Override
    public ExtendedResponseDecorator<?> decorate(org.apache.directory.api.ldap.model.message.ExtendedResponse decoratedMessage) {
        ExtendedResponseDecorator<org.apache.directory.api.ldap.model.message.ExtendedResponse> resp = null;
        ExtendedOperationFactory extendedRequestFactory = this.extendedOperationsFactories.get(decoratedMessage.getResponseName());
        resp = extendedRequestFactory != null ? (ExtendedResponseDecorator<org.apache.directory.api.ldap.model.message.ExtendedResponse>)extendedRequestFactory.decorate(decoratedMessage) : new ExtendedResponseDecorator<org.apache.directory.api.ldap.model.message.ExtendedResponse>((LdapApiService)this, decoratedMessage);
        return resp;
    }

    @Override
    public boolean isExtendedOperationRegistered(String oid) {
        return this.extendedOperationsFactories.containsKey(oid);
    }
}

