/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAffectMultipleDsaException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.exception.LdapPartialResultException;
import org.apache.directory.api.ldap.model.exception.LdapReferralException;
import org.apache.directory.api.ldap.model.exception.LdapServiceUnavailableException;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.OperationManager;
import org.apache.directory.server.core.api.ReferralManager;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.GetRootDseOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOperationManager
implements OperationManager {
    private static final Logger OPERATION_LOG = LoggerFactory.getLogger(Loggers.OPERATION_LOG.getName());
    private static final Logger OPERATION_TIME = LoggerFactory.getLogger(Loggers.OPERATION_TIME.getName());
    private static final Logger OPERATION_STAT = LoggerFactory.getLogger(Loggers.OPERATION_STAT.getName());
    private static final boolean IS_DEBUG = OPERATION_LOG.isDebugEnabled();
    private static final boolean IS_TIME = OPERATION_TIME.isDebugEnabled();
    private static final boolean IS_STAT = OPERATION_STAT.isDebugEnabled();
    private final DirectoryService directoryService;
    private ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    public DefaultOperationManager(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    @Override
    public ReadWriteLock getRWLock() {
        return this.rwLock;
    }

    @Override
    public void lockRead() {
        this.rwLock.readLock().lock();
    }

    @Override
    public void lockWrite() {
        this.rwLock.writeLock().lock();
    }

    @Override
    public void unlockWrite() {
        this.rwLock.writeLock().unlock();
    }

    @Override
    public void unlockRead() {
        this.rwLock.readLock().unlock();
    }

    private void eagerlyPopulateFields(OperationContext opContext) throws LdapException {
        if (opContext.getEntry() == null) {
            CoreSession adminSession = opContext.getSession().getDirectoryService().getAdminSession();
            LookupOperationContext lookupContext = new LookupOperationContext(adminSession, opContext.getDn(), SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            Entry foundEntry = opContext.getSession().getDirectoryService().getPartitionNexus().lookup(lookupContext);
            if (foundEntry != null) {
                opContext.setEntry(foundEntry);
            } else {
                LdapNoSuchObjectException ldnfe = new LdapNoSuchObjectException(I18n.err(I18n.ERR_256_NO_SUCH_OBJECT, opContext.getDn()));
                throw ldnfe;
            }
        }
    }

    private Entry getOriginalEntry(OperationContext opContext) throws LdapException {
        CoreSession adminSession = opContext.getSession().getDirectoryService().getAdminSession();
        Entry foundEntry = adminSession.lookup(opContext.getDn(), "+", "*");
        if (foundEntry != null) {
            return foundEntry;
        }
        LdapNoSuchObjectException ldnfe = new LdapNoSuchObjectException(I18n.err(I18n.ERR_256_NO_SUCH_OBJECT, opContext.getDn()));
        throw ldnfe;
    }

    private LdapReferralException buildReferralException(Entry parentEntry, Dn childDn) throws LdapException {
        Attribute refs = parentEntry.get("ref");
        ArrayList<String> urls = new ArrayList<String>();
        try {
            for (Value url : refs) {
                LdapUrl ldapUrl = new LdapUrl(url.getString());
                Dn urlDn = ldapUrl.getDn().add(childDn);
                ldapUrl.setDn(urlDn);
                urls.add(ldapUrl.toString());
            }
        }
        catch (LdapURLEncodingException luee) {
            throw new LdapOperationErrorException(luee.getMessage(), luee);
        }
        LdapReferralException lre = new LdapReferralException(urls);
        lre.setRemainingDn(childDn);
        lre.setResolvedDn(parentEntry.getDn());
        lre.setResolvedObject(parentEntry);
        return lre;
    }

    private LdapReferralException buildReferralExceptionForSearch(Entry parentEntry, Dn childDn, SearchScope scope) throws LdapException {
        Attribute refs = parentEntry.get("ref");
        ArrayList<String> urls = new ArrayList<String>();
        for (Value url : refs) {
            try {
                LdapUrl ldapUrl = new LdapUrl(url.getString());
                StringBuilder urlString = new StringBuilder();
                if (ldapUrl.getDn() == null || ldapUrl.getDn() == Dn.ROOT_DSE) {
                    ldapUrl.setDn(parentEntry.getDn());
                } else {
                    Dn urlDn = ldapUrl.getDn().add(childDn);
                    ldapUrl.setDn(urlDn);
                }
                urlString.append(ldapUrl.toString()).append("??");
                switch (scope) {
                    case OBJECT: {
                        urlString.append("base");
                        break;
                    }
                    case SUBTREE: {
                        urlString.append("sub");
                        break;
                    }
                    case ONELEVEL: {
                        urlString.append("one");
                    }
                }
                urls.add(urlString.toString());
            }
            catch (LdapURLEncodingException luee) {
                urls.add(url.getString());
            }
        }
        LdapReferralException lre = new LdapReferralException(urls);
        lre.setRemainingDn(childDn);
        lre.setResolvedDn(parentEntry.getDn());
        lre.setResolvedObject(parentEntry);
        return lre;
    }

    private LdapPartialResultException buildLdapPartialResultException(Dn childDn) {
        LdapPartialResultException lpre = new LdapPartialResultException(I18n.err(I18n.ERR_315, new Object[0]));
        lpre.setRemainingDn(childDn);
        lpre.setResolvedDn(Dn.EMPTY_DN);
        return lpre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> AddOperation : {}", (Object)addContext);
        }
        long addStart = 0L;
        if (IS_TIME) {
            addStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = addContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        this.directoryService.getReferralManager().lockRead();
        try {
            if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (addContext.isReferralIgnored()) {
                    LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                    throw exception;
                }
                LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                throw exception;
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        Interceptor head = this.directoryService.getInterceptor(addContext.getNextInterceptor());
        this.lockWrite();
        try {
            head.add(addContext);
        }
        finally {
            this.unlockWrite();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< AddOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Add operation took " + (System.nanoTime() - addStart) + " ns");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(BindOperationContext bindContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> BindOperation : {}", (Object)bindContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(bindContext.getNextInterceptor());
        this.lockRead();
        try {
            head.bind(bindContext);
        }
        finally {
            this.unlockRead();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< BindOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Bind operation took " + (System.nanoTime() - opStart) + " ns");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> CompareOperation : {}", (Object)compareContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = compareContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        this.directoryService.getReferralManager().lockRead();
        try {
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!compareContext.isReferralIgnored()) {
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (compareContext.isReferralIgnored()) {
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        compareContext.setOriginalEntry(this.getOriginalEntry(compareContext));
        Interceptor head = this.directoryService.getInterceptor(compareContext.getNextInterceptor());
        boolean result = false;
        this.lockRead();
        try {
            result = head.compare(compareContext);
        }
        finally {
            this.unlockRead();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< CompareOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Compare operation took " + (System.nanoTime() - opStart) + " ns");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> DeleteOperation : {}", (Object)deleteContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = deleteContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        this.directoryService.getReferralManager().lockRead();
        try {
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!deleteContext.isReferralIgnored()) {
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (deleteContext.isReferralIgnored()) {
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        this.lockWrite();
        try {
            this.eagerlyPopulateFields(deleteContext);
            Interceptor head = this.directoryService.getInterceptor(deleteContext.getNextInterceptor());
            head.delete(deleteContext);
        }
        finally {
            this.unlockWrite();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< DeleteOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Delete operation took " + (System.nanoTime() - opStart) + " ns");
        }
    }

    @Override
    public Entry getRootDse(GetRootDseOperationContext getRootDseContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> GetRootDseOperation : {}", (Object)getRootDseContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(getRootDseContext.getNextInterceptor());
        Entry root = head.getRootDse(getRootDseContext);
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< getRootDseOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("GetRootDSE operation took " + (System.nanoTime() - opStart) + " ns");
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEntry(HasEntryOperationContext hasEntryContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> hasEntryOperation : {}", (Object)hasEntryContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(hasEntryContext.getNextInterceptor());
        boolean result = false;
        this.lockRead();
        try {
            result = head.hasEntry(hasEntryContext);
        }
        finally {
            this.unlockRead();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< HasEntryOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("HasEntry operation took " + (System.nanoTime() - opStart) + " ns");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> LookupOperation : {}", (Object)lookupContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(lookupContext.getNextInterceptor());
        Entry entry = null;
        this.lockRead();
        try {
            entry = head.lookup(lookupContext);
        }
        finally {
            this.unlockRead();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< LookupOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Lookup operation took " + (System.nanoTime() - opStart) + " ns");
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> ModifyOperation : {}", (Object)modifyContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = modifyContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        ReferralManager referralManager = this.directoryService.getReferralManager();
        referralManager.lockRead();
        try {
            Entry parentEntry = referralManager.getParentReferral(dn);
            if (parentEntry != null) {
                if (referralManager.isReferral(dn)) {
                    if (!modifyContext.isReferralIgnored()) {
                        Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (referralManager.hasParentReferral(dn)) {
                    if (modifyContext.isReferralIgnored()) {
                        Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
        }
        finally {
            referralManager.unlock();
        }
        this.lockWrite();
        try {
            this.eagerlyPopulateFields(modifyContext);
            Interceptor head = this.directoryService.getInterceptor(modifyContext.getNextInterceptor());
            head.modify(modifyContext);
        }
        finally {
            this.unlockWrite();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< ModifyOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Modify operation took " + (System.nanoTime() - opStart) + " ns");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> MoveOperation : {}", (Object)moveContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = moveContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        Dn newSuperiorDn = moveContext.getNewSuperior();
        newSuperiorDn.apply(this.directoryService.getSchemaManager());
        this.directoryService.getReferralManager().lockRead();
        try {
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!moveContext.isReferralIgnored()) {
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (moveContext.isReferralIgnored()) {
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            if (this.directoryService.getReferralManager().isReferral(newSuperiorDn) || this.directoryService.getReferralManager().hasParentReferral(newSuperiorDn)) {
                LdapAffectMultipleDsaException exception = new LdapAffectMultipleDsaException();
                throw exception;
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        this.lockWrite();
        try {
            Entry originalEntry = this.getOriginalEntry(moveContext);
            moveContext.setOriginalEntry(originalEntry);
            Interceptor head = this.directoryService.getInterceptor(moveContext.getNextInterceptor());
            head.move(moveContext);
        }
        finally {
            this.unlockWrite();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< MoveOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Move operation took " + (System.nanoTime() - opStart) + " ns");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> MoveAndRenameOperation : {}", (Object)moveAndRenameContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = moveAndRenameContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        this.directoryService.getReferralManager().lockRead();
        try {
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!moveAndRenameContext.isReferralIgnored()) {
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (moveAndRenameContext.isReferralIgnored()) {
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            Dn newSuperiorDn = moveAndRenameContext.getNewSuperiorDn();
            newSuperiorDn.apply(this.directoryService.getSchemaManager());
            if (this.directoryService.getReferralManager().isReferral(newSuperiorDn) || this.directoryService.getReferralManager().hasParentReferral(newSuperiorDn)) {
                LdapAffectMultipleDsaException exception = new LdapAffectMultipleDsaException();
                throw exception;
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        this.lockWrite();
        try {
            moveAndRenameContext.setOriginalEntry(this.getOriginalEntry(moveAndRenameContext));
            moveAndRenameContext.setModifiedEntry(moveAndRenameContext.getOriginalEntry().clone());
            Interceptor head = this.directoryService.getInterceptor(moveAndRenameContext.getNextInterceptor());
            head.moveAndRename(moveAndRenameContext);
        }
        finally {
            this.unlockWrite();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< MoveAndRenameOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("MoveAndRename operation took " + (System.nanoTime() - opStart) + " ns");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> RenameOperation : {}", (Object)renameContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = renameContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        if (!dn.isEmpty()) {
            Dn newDn = dn.getParent();
            newDn = newDn.add(renameContext.getNewRdn());
            renameContext.setNewDn(newDn);
        }
        this.directoryService.getReferralManager().lockRead();
        try {
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!renameContext.isReferralIgnored()) {
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (renameContext.isReferralIgnored()) {
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        this.lockWrite();
        try {
            this.eagerlyPopulateFields(renameContext);
            Entry originalEntry = this.getOriginalEntry(renameContext);
            renameContext.setOriginalEntry(originalEntry);
            renameContext.setModifiedEntry(originalEntry.clone());
            Interceptor head = this.directoryService.getInterceptor(renameContext.getNextInterceptor());
            head.rename(renameContext);
        }
        finally {
            this.unlockWrite();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< RenameOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Rename operation took " + (System.nanoTime() - opStart) + " ns");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> SearchOperation : {}", (Object)searchContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = searchContext.getDn();
        dn.apply(this.directoryService.getSchemaManager());
        this.directoryService.getReferralManager().lockRead();
        try {
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!searchContext.isReferralIgnored()) {
                        LdapReferralException exception = this.buildReferralExceptionForSearch(parentEntry, childDn, searchContext.getScope());
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (searchContext.isReferralIgnored()) {
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    LdapReferralException exception = this.buildReferralExceptionForSearch(parentEntry, childDn, searchContext.getScope());
                    throw exception;
                }
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        Interceptor head = this.directoryService.getInterceptor(searchContext.getNextInterceptor());
        EntryFilteringCursor cursor = null;
        this.lockRead();
        try {
            cursor = head.search(searchContext);
        }
        finally {
            this.unlockRead();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< SearchOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Search operation took " + (System.nanoTime() - opStart) + " ns");
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(UnbindOperationContext unbindContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> UnbindOperation : {}", (Object)unbindContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(unbindContext.getNextInterceptor());
        head.unbind(unbindContext);
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< UnbindOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Unbind operation took " + (System.nanoTime() - opStart) + " ns");
        }
    }

    private void ensureStarted() throws LdapServiceUnavailableException {
        if (!this.directoryService.isStarted()) {
            throw new LdapServiceUnavailableException(ResultCodeEnum.UNAVAILABLE, I18n.err(I18n.ERR_316, new Object[0]));
        }
    }
}

