/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.password;

import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.util.Strings;

public class EncryptionMethod {
    private byte[] salt;
    private LdapSecurityConstants algorithm;

    public EncryptionMethod(LdapSecurityConstants algorithm, byte[] salt) {
        this.algorithm = algorithm;
        this.salt = salt;
    }

    public LdapSecurityConstants getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(byte[] salt) {
        if (this.salt != null) {
            throw new IllegalStateException("salt will only be allowed to set once");
        }
        this.salt = salt;
    }

    public String toString() {
        return "EncryptionMethod [algorithm=" + this.algorithm.getName().toUpperCase() + ", salt=" + Strings.dumpBytes(this.salt) + "]";
    }
}

