/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.mavibot.btree.AbstractBTree;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.InMemoryLeaf;
import org.apache.directory.mavibot.btree.InMemoryNode;
import org.apache.directory.mavibot.btree.InMemoryValueHolder;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;

public class InMemoryBTreeBuilder<K, V> {
    private String name;
    private int numKeysInNode;
    private ElementSerializer<K> keySerializer;
    private ElementSerializer<V> valueSerializer;

    public InMemoryBTreeBuilder(String name, int numKeysInNode, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer) {
        this.name = name;
        this.numKeysInNode = numKeysInNode;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public BTree<K, V> build(Iterator<Tuple<K, V>> sortedTupleItr) throws IOException {
        BTree<K, V> btree = BTreeFactory.createInMemoryBTree(this.name, this.keySerializer, this.valueSerializer);
        ArrayList<Page<K, V>> lstLeaves = new ArrayList<Page<K, V>>();
        int totalTupleCount = 0;
        InMemoryLeaf leaf1 = (InMemoryLeaf)BTreeFactory.createLeaf(btree, 0L, this.numKeysInNode);
        lstLeaves.add(leaf1);
        int leafIndex = 0;
        while (sortedTupleItr.hasNext()) {
            Tuple<K, V> tuple = sortedTupleItr.next();
            BTreeFactory.setKey(btree, leaf1, leafIndex, tuple.getKey());
            InMemoryValueHolder<Object> eh = new InMemoryValueHolder<Object>(btree, tuple.getValue());
            BTreeFactory.setValue(btree, leaf1, leafIndex, eh);
            ++leafIndex;
            if (++totalTupleCount % this.numKeysInNode != 0) continue;
            leafIndex = 0;
            leaf1 = (InMemoryLeaf)BTreeFactory.createLeaf(btree, 0L, this.numKeysInNode);
            lstLeaves.add(leaf1);
        }
        if (lstLeaves.isEmpty()) {
            return btree;
        }
        InMemoryLeaf lastLeaf = (InMemoryLeaf)lstLeaves.get(lstLeaves.size() - 1);
        for (int i = 0; i < lastLeaf.getNbElems(); ++i) {
            if (lastLeaf.getKeys()[i] != null) continue;
            int n = i;
            lastLeaf.setNbElems(n);
            KeyHolder<K>[] keys = lastLeaf.getKeys();
            lastLeaf.setKeys((KeyHolder[])Array.newInstance(KeyHolder.class, n));
            System.arraycopy(keys, 0, lastLeaf.getKeys(), 0, n);
            ValueHolder<V>[] values = lastLeaf.values;
            lastLeaf.values = (InMemoryValueHolder[])Array.newInstance(InMemoryValueHolder.class, n);
            System.arraycopy(values, 0, lastLeaf.values, 0, n);
            break;
        }
        Page<K, V> rootPage = this.attachNodes(lstLeaves, btree);
        System.out.println("built rootpage : " + rootPage);
        ((AbstractBTree)btree).setRootPage(rootPage);
        return btree;
    }

    private Page<K, V> attachNodes(List<Page<K, V>> children, BTree<K, V> btree) throws IOException {
        if (children.size() == 1) {
            return children.get(0);
        }
        ArrayList<Page<K, V>> lstNodes = new ArrayList<Page<K, V>>();
        int numChildren = this.numKeysInNode + 1;
        InMemoryNode node = (InMemoryNode)BTreeFactory.createNode(btree, 0L, this.numKeysInNode);
        lstNodes.add(node);
        int i = 0;
        int totalNodes = 0;
        for (Page<K, V> p : children) {
            if (i != 0) {
                BTreeFactory.setKey(btree, node, i - 1, p.getLeftMostKey());
            }
            node.setPageHolder(i, new PageHolder<K, V>(btree, p));
            ++i;
            if (++totalNodes % numChildren != 0) continue;
            i = 0;
            node = (InMemoryNode)BTreeFactory.createNode(btree, 0L, this.numKeysInNode);
            lstNodes.add(node);
        }
        AbstractPage lastNode = (AbstractPage)lstNodes.get(lstNodes.size() - 1);
        for (int j = 0; j < lastNode.getNbElems(); ++j) {
            if (lastNode.getKey(j) != null) continue;
            int n = j;
            lastNode.setNbElems(n);
            KeyHolder<K>[] keys = lastNode.getKeys();
            lastNode.setKeys((KeyHolder[])Array.newInstance(KeyHolder.class, n));
            System.arraycopy(keys, 0, lastNode.getKeys(), 0, n);
            break;
        }
        return this.attachNodes(lstNodes, btree);
    }
}

