/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.IOException;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapConnectionFactory
implements LdapConnectionFactory {
    private static Logger LOG = LoggerFactory.getLogger(DefaultLdapConnectionFactory.class);
    private LdapApiService apiService;
    private LdapConnectionConfig connectionConfig;
    private long timeout;

    public DefaultLdapConnectionFactory(LdapConnectionConfig config) {
        this.connectionConfig = config;
        this.timeout = config.getDefaultTimeout();
    }

    @Override
    public LdapConnection bindConnection(LdapConnection connection) throws LdapException {
        try {
            connection.bind(this.connectionConfig.getName(), this.connectionConfig.getCredentials());
        }
        catch (LdapException e) {
            LOG.error("unable to bind connection: {}", (Object)e.getMessage());
            LOG.debug("unable to bind connection:", e);
            try {
                connection.close();
            }
            catch (IOException ioe) {
                LOG.error("unable to close failed bind connection: {}", (Object)e.getMessage());
                LOG.debug("unable to close failed bind connection:", e);
            }
            throw e;
        }
        return connection;
    }

    @Override
    public LdapConnection configureConnection(LdapConnection connection) {
        connection.setTimeOut(this.timeout);
        connection.setBinaryAttributeDetector(this.connectionConfig.getBinaryAttributeDetector());
        return connection;
    }

    @Override
    public LdapApiService getLdapApiService() {
        return this.apiService;
    }

    @Override
    public LdapConnection newLdapConnection() throws LdapException {
        return this.bindConnection(this.newUnboundLdapConnection());
    }

    @Override
    public LdapConnection newUnboundLdapConnection() {
        return this.configureConnection(this.apiService == null ? new LdapNetworkConnection(this.connectionConfig) : new LdapNetworkConnection(this.connectionConfig, this.apiService));
    }

    public void setLdapApiService(LdapApiService apiService) {
        this.apiService = apiService;
    }

    public void setTimeOut(long timeout) {
        this.timeout = timeout;
    }
}

