/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidSearchFilterException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.FilterParser;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.CompareResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.DeleteResponse;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.UnbindRequest;
import org.apache.directory.api.ldap.model.message.controls.SortKey;
import org.apache.directory.api.ldap.model.message.controls.SortRequestControl;
import org.apache.directory.api.ldap.model.message.controls.SortResponseControl;
import org.apache.directory.api.ldap.model.message.controls.SortResponseControlImpl;
import org.apache.directory.api.ldap.model.message.controls.SortResultCode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.PersistedBTreeConfiguration;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.exception.BTreeAlreadyManagedException;
import org.apache.directory.mavibot.btree.serializer.StringSerializer;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.OperationManager;
import org.apache.directory.server.core.api.changelog.LogChange;
import org.apache.directory.server.core.api.interceptor.context.AbstractOperationContext;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.shared.SortedEntryComparator;
import org.apache.directory.server.core.shared.SortedEntryCursor;
import org.apache.directory.server.core.shared.SortedEntrySerializer;
import org.apache.directory.server.i18n.I18n;
import org.apache.mina.core.session.IoSession;

public class DefaultCoreSession
implements CoreSession {
    private final DirectoryService directoryService;
    private final LdapPrincipal authenticatedPrincipal;
    private final LdapPrincipal anonymousPrincipal;
    private LdapPrincipal authorizedPrincipal;
    protected AttributeType OBJECT_CLASS_AT;
    private IoSession ioSession;

    public DefaultCoreSession(LdapPrincipal principal, DirectoryService directoryService) {
        this.directoryService = directoryService;
        this.authenticatedPrincipal = principal;
        this.anonymousPrincipal = principal.getAuthenticationLevel() == AuthenticationLevel.NONE ? principal : new LdapPrincipal(directoryService.getSchemaManager());
        this.OBJECT_CLASS_AT = directoryService.getSchemaManager().getAttributeType("objectClass");
    }

    public void setIoSession(IoSession ioSession) {
        this.ioSession = ioSession;
    }

    private void setReferralHandling(AbstractOperationContext opContext, boolean ignoreReferral) {
        if (ignoreReferral) {
            opContext.ignoreReferral();
        } else {
            opContext.throwReferral();
        }
    }

    @Override
    public void add(Entry entry) throws LdapException {
        this.add(entry, LogChange.TRUE);
    }

    @Override
    public void add(Entry entry, boolean ignoreReferral) throws LdapException {
        this.add(entry, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void add(Entry entry, LogChange log) throws LdapException {
        AddOperationContext addContext = new AddOperationContext((CoreSession)this, entry);
        addContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.add(addContext);
    }

    @Override
    public void add(Entry entry, boolean ignoreReferral, LogChange log) throws LdapException {
        AddOperationContext addContext = new AddOperationContext((CoreSession)this, entry);
        addContext.setLogChange(log);
        this.setReferralHandling(addContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.add(addContext);
    }

    @Override
    public void add(AddRequest addRequest) throws LdapException {
        this.add(addRequest, LogChange.TRUE);
    }

    @Override
    public void add(AddRequest addRequest, LogChange log) throws LdapException {
        AddOperationContext addContext = new AddOperationContext((CoreSession)this, addRequest);
        addContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.add(addContext);
        }
        catch (LdapException e) {
            ((AddResponse)addRequest.getResultResponse()).addAllControls(addContext.getResponseControls());
            throw e;
        }
        ((AddResponse)addRequest.getResultResponse()).addAllControls(addContext.getResponseControls());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value<?> convertToValue(String oid, Object value) throws LdapException {
        void var3_8;
        Object var3_3 = null;
        AttributeType attributeType = this.directoryService.getSchemaManager().lookupAttributeTypeRegistry(oid);
        if (attributeType.getSyntax().isHumanReadable()) {
            if (value instanceof String) {
                StringValue stringValue = new StringValue(attributeType, (String)value);
                return var3_8;
            } else {
                if (!(value instanceof byte[])) throw new LdapException(I18n.err(I18n.ERR_309, oid));
                StringValue stringValue = new StringValue(attributeType, Strings.utf8ToString((byte[])value));
            }
            return var3_8;
        } else if (value instanceof String) {
            BinaryValue binaryValue = new BinaryValue(attributeType, Strings.getBytesUtf8((String)value));
            return var3_8;
        } else {
            if (!(value instanceof byte[])) throw new LdapException(I18n.err(I18n.ERR_309, oid));
            BinaryValue binaryValue = new BinaryValue(attributeType, (byte[])value);
        }
        return var3_8;
    }

    @Override
    public boolean compare(Dn dn, String oid, Object value) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.compare(new CompareOperationContext(this, dn, oid, this.convertToValue(oid, value)));
    }

    @Override
    public boolean compare(Dn dn, String oid, Object value, boolean ignoreReferral) throws LdapException {
        CompareOperationContext compareContext = new CompareOperationContext(this, dn, oid, this.convertToValue(oid, value));
        this.setReferralHandling(compareContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.compare(compareContext);
    }

    @Override
    public void delete(Dn dn) throws LdapException {
        this.delete(dn, LogChange.TRUE);
    }

    @Override
    public void delete(Dn dn, LogChange log) throws LdapException {
        DeleteOperationContext deleteContext = new DeleteOperationContext((CoreSession)this, dn);
        deleteContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.delete(deleteContext);
    }

    @Override
    public void delete(Dn dn, boolean ignoreReferral) throws LdapException {
        this.delete(dn, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void delete(Dn dn, boolean ignoreReferral, LogChange log) throws LdapException {
        DeleteOperationContext deleteContext = new DeleteOperationContext((CoreSession)this, dn);
        deleteContext.setLogChange(log);
        this.setReferralHandling(deleteContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.delete(deleteContext);
    }

    @Override
    public LdapPrincipal getAnonymousPrincipal() {
        return this.anonymousPrincipal;
    }

    @Override
    public LdapPrincipal getAuthenticatedPrincipal() {
        return this.authenticatedPrincipal;
    }

    @Override
    public AuthenticationLevel getAuthenticationLevel() {
        return this.getEffectivePrincipal().getAuthenticationLevel();
    }

    @Override
    public SocketAddress getClientAddress() {
        if (this.ioSession != null) {
            return this.ioSession.getRemoteAddress();
        }
        return null;
    }

    @Override
    public Set<Control> getControls() {
        return null;
    }

    @Override
    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    @Override
    public LdapPrincipal getEffectivePrincipal() {
        if (this.authorizedPrincipal == null) {
            return this.authenticatedPrincipal;
        }
        return this.authorizedPrincipal;
    }

    @Override
    public Set<OperationContext> getOutstandingOperations() {
        return null;
    }

    @Override
    public SocketAddress getServiceAddress() {
        if (this.ioSession != null) {
            return this.ioSession.getServiceAddress();
        }
        return null;
    }

    @Override
    public boolean isConfidential() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public boolean isAdministrator() {
        String normName = this.getEffectivePrincipal().getName();
        return normName.equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
    }

    @Override
    public boolean isAnAdministrator() {
        return this.isAdministrator();
    }

    @Override
    public Cursor<Entry> list(Dn dn, AliasDerefMode aliasDerefMode, String ... returningAttributes) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        PresenceNode filter = new PresenceNode(this.OBJECT_CLASS_AT);
        SearchOperationContext searchContext = new SearchOperationContext((CoreSession)this, dn, SearchScope.ONELEVEL, filter, returningAttributes);
        searchContext.setAliasDerefMode(aliasDerefMode);
        return operationManager.search(searchContext);
    }

    @Override
    public Entry lookup(Dn dn, String ... attrIds) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        LookupOperationContext lookupContext = new LookupOperationContext((CoreSession)this, dn, attrIds);
        Entry entry = operationManager.lookup(lookupContext);
        return entry;
    }

    @Override
    public Entry lookup(Dn dn, Control[] controls, String ... attrIds) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        LookupOperationContext lookupContext = new LookupOperationContext((CoreSession)this, dn, attrIds);
        if (controls != null) {
            lookupContext.addRequestControls(controls);
        }
        Entry entry = operationManager.lookup(lookupContext);
        return entry;
    }

    @Override
    public void modify(Dn dn, Modification ... mods) throws LdapException {
        this.modify(dn, Arrays.asList(mods), LogChange.TRUE);
    }

    @Override
    public void modify(Dn dn, List<Modification> mods) throws LdapException {
        this.modify(dn, mods, LogChange.TRUE);
    }

    @Override
    public void modify(Dn dn, List<Modification> mods, LogChange log) throws LdapException {
        if (mods == null) {
            return;
        }
        ArrayList<Modification> serverModifications = new ArrayList<Modification>(mods.size());
        for (Modification mod : mods) {
            serverModifications.add(new DefaultModification(this.directoryService.getSchemaManager(), mod));
        }
        ModifyOperationContext modifyContext = new ModifyOperationContext(this, dn, serverModifications);
        modifyContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.modify(modifyContext);
    }

    @Override
    public void modify(Dn dn, List<Modification> mods, boolean ignoreReferral) throws LdapException {
        this.modify(dn, mods, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void modify(Dn dn, List<Modification> mods, boolean ignoreReferral, LogChange log) throws LdapException {
        if (mods == null) {
            return;
        }
        ArrayList<Modification> serverModifications = new ArrayList<Modification>(mods.size());
        for (Modification mod : mods) {
            serverModifications.add(new DefaultModification(this.directoryService.getSchemaManager(), mod));
        }
        ModifyOperationContext modifyContext = new ModifyOperationContext(this, dn, serverModifications);
        this.setReferralHandling(modifyContext, ignoreReferral);
        modifyContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.modify(modifyContext);
    }

    @Override
    public void move(Dn dn, Dn newParent) throws LdapException {
        this.move(dn, newParent, LogChange.TRUE);
    }

    @Override
    public void move(Dn dn, Dn newParent, LogChange log) throws LdapException {
        MoveOperationContext moveContext = new MoveOperationContext(this, dn, newParent);
        moveContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.move(moveContext);
    }

    @Override
    public void move(Dn dn, Dn newParent, boolean ignoreReferral) throws Exception {
        this.move(dn, newParent, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void move(Dn dn, Dn newParent, boolean ignoreReferral, LogChange log) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        MoveOperationContext moveContext = new MoveOperationContext(this, dn, newParent);
        this.setReferralHandling(moveContext, ignoreReferral);
        moveContext.setLogChange(log);
        operationManager.move(moveContext);
    }

    @Override
    public void moveAndRename(Dn dn, Dn newParent, Rdn newRdn, boolean deleteOldRdn) throws LdapException {
        this.moveAndRename(dn, newParent, newRdn, deleteOldRdn, LogChange.TRUE);
    }

    @Override
    public void moveAndRename(Dn dn, Dn newSuperiorDn, Rdn newRdn, boolean deleteOldRdn, LogChange log) throws LdapException {
        MoveAndRenameOperationContext moveAndRenameContext = new MoveAndRenameOperationContext(this, dn, newSuperiorDn, newRdn, deleteOldRdn);
        moveAndRenameContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.moveAndRename(moveAndRenameContext);
    }

    @Override
    public void moveAndRename(Dn dn, Dn newParent, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral) throws LdapException {
        this.moveAndRename(dn, newParent, newRdn, deleteOldRdn, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void moveAndRename(Dn dn, Dn newParent, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral, LogChange log) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        MoveAndRenameOperationContext moveAndRenameContext = new MoveAndRenameOperationContext(this, dn, newParent, newRdn, deleteOldRdn);
        moveAndRenameContext.setLogChange(log);
        this.setReferralHandling(moveAndRenameContext, ignoreReferral);
        operationManager.moveAndRename(moveAndRenameContext);
    }

    @Override
    public void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn) throws LdapException {
        this.rename(dn, newRdn, deleteOldRdn, LogChange.TRUE);
    }

    @Override
    public void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn, LogChange log) throws LdapException {
        RenameOperationContext renameContext = new RenameOperationContext(this, dn, newRdn, deleteOldRdn);
        renameContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.rename(renameContext);
    }

    @Override
    public void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral) throws LdapException {
        this.rename(dn, newRdn, deleteOldRdn, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral, LogChange log) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        RenameOperationContext renameContext = new RenameOperationContext(this, dn, newRdn, deleteOldRdn);
        renameContext.setLogChange(log);
        this.setReferralHandling(renameContext, ignoreReferral);
        operationManager.rename(renameContext);
    }

    @Override
    public Cursor<Entry> search(Dn dn, String filter) throws LdapException {
        return this.search(dn, filter, true);
    }

    @Override
    public Cursor<Entry> search(Dn dn, String filter, boolean ignoreReferrals) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        ExprNode filterNode = null;
        try {
            filterNode = FilterParser.parse(this.directoryService.getSchemaManager(), filter);
        }
        catch (ParseException pe) {
            throw new LdapInvalidSearchFilterException(pe.getMessage());
        }
        SearchOperationContext searchContext = new SearchOperationContext((CoreSession)this, dn, SearchScope.OBJECT, filterNode, new String[]{null});
        searchContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
        this.setReferralHandling(searchContext, ignoreReferrals);
        return operationManager.search(searchContext);
    }

    @Override
    public Cursor<Entry> search(Dn dn, SearchScope scope, ExprNode filter, AliasDerefMode aliasDerefMode, String ... returningAttributes) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        SearchOperationContext searchContext = new SearchOperationContext((CoreSession)this, dn, scope, filter, returningAttributes);
        searchContext.setAliasDerefMode(aliasDerefMode);
        return operationManager.search(searchContext);
    }

    @Override
    public boolean isAnonymous() {
        if (this.authorizedPrincipal == null && this.authenticatedPrincipal == null) {
            return true;
        }
        return this.authenticatedPrincipal.getAuthenticationLevel() == AuthenticationLevel.NONE;
    }

    @Override
    public boolean compare(CompareRequest compareRequest) throws LdapException {
        CompareOperationContext compareContext = new CompareOperationContext((CoreSession)this, compareRequest);
        OperationManager operationManager = this.directoryService.getOperationManager();
        boolean result = false;
        try {
            result = operationManager.compare(compareContext);
        }
        catch (LdapException e) {
            ((CompareResponse)compareRequest.getResultResponse()).addAllControls(compareContext.getResponseControls());
            throw e;
        }
        ((CompareResponse)compareRequest.getResultResponse()).addAllControls(compareContext.getResponseControls());
        return result;
    }

    @Override
    public void delete(DeleteRequest deleteRequest) throws LdapException {
        this.delete(deleteRequest, LogChange.TRUE);
    }

    @Override
    public void delete(DeleteRequest deleteRequest, LogChange log) throws LdapException {
        DeleteOperationContext deleteContext = new DeleteOperationContext((CoreSession)this, deleteRequest);
        deleteContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.delete(deleteContext);
        }
        catch (LdapException e) {
            ((DeleteResponse)deleteRequest.getResultResponse()).addAllControls(deleteContext.getResponseControls());
            throw e;
        }
        ((DeleteResponse)deleteRequest.getResultResponse()).addAllControls(deleteContext.getResponseControls());
    }

    @Override
    public boolean exists(String dn) throws LdapException {
        return this.exists(new Dn(dn));
    }

    @Override
    public boolean exists(Dn dn) throws LdapException {
        HasEntryOperationContext hasEntryContext = new HasEntryOperationContext(this, dn);
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.hasEntry(hasEntryContext);
    }

    @Override
    public void modify(ModifyRequest modifyRequest) throws LdapException {
        this.modify(modifyRequest, LogChange.TRUE);
    }

    @Override
    public void modify(ModifyRequest modifyRequest, LogChange log) throws LdapException {
        ModifyOperationContext modifyContext = new ModifyOperationContext((CoreSession)this, modifyRequest);
        modifyContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.modify(modifyContext);
        }
        catch (LdapException e) {
            ((ModifyResponse)modifyRequest.getResultResponse()).addAllControls(modifyContext.getResponseControls());
            throw e;
        }
        ((ModifyResponse)modifyRequest.getResultResponse()).addAllControls(modifyContext.getResponseControls());
    }

    @Override
    public void move(ModifyDnRequest modifyDnRequest) throws LdapException {
        this.move(modifyDnRequest, LogChange.TRUE);
    }

    @Override
    public void move(ModifyDnRequest modifyDnRequest, LogChange log) throws LdapException {
        MoveOperationContext moveContext = new MoveOperationContext((CoreSession)this, modifyDnRequest);
        moveContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.move(moveContext);
        }
        catch (LdapException e) {
            ((ModifyDnResponse)modifyDnRequest.getResultResponse()).addAllControls(moveContext.getResponseControls());
            throw e;
        }
        ((ModifyDnResponse)modifyDnRequest.getResultResponse()).addAllControls(moveContext.getResponseControls());
    }

    @Override
    public void moveAndRename(ModifyDnRequest modifyDnRequest) throws LdapException {
        this.moveAndRename(modifyDnRequest, LogChange.TRUE);
    }

    @Override
    public void moveAndRename(ModifyDnRequest modifyDnRequest, LogChange log) throws LdapException {
        MoveAndRenameOperationContext moveAndRenameContext = new MoveAndRenameOperationContext((CoreSession)this, modifyDnRequest);
        moveAndRenameContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.moveAndRename(moveAndRenameContext);
        }
        catch (LdapException e) {
            ((ModifyDnResponse)modifyDnRequest.getResultResponse()).addAllControls(moveAndRenameContext.getResponseControls());
            throw e;
        }
        ((ModifyDnResponse)modifyDnRequest.getResultResponse()).addAllControls(moveAndRenameContext.getResponseControls());
    }

    @Override
    public void rename(ModifyDnRequest modifyDnRequest) throws LdapException {
        this.rename(modifyDnRequest, LogChange.TRUE);
    }

    @Override
    public void rename(ModifyDnRequest modifyDnRequest, LogChange log) throws LdapException {
        RenameOperationContext renameContext = new RenameOperationContext((CoreSession)this, modifyDnRequest);
        renameContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.rename(renameContext);
        }
        catch (LdapException e) {
            ((ModifyDnResponse)modifyDnRequest.getResultResponse()).addAllControls(renameContext.getResponseControls());
            throw e;
        }
        ((ModifyDnResponse)modifyDnRequest.getResultResponse()).addAllControls(renameContext.getResponseControls());
    }

    @Override
    public Cursor<Entry> search(SearchRequest searchRequest) throws LdapException {
        SearchOperationContext searchContext = new SearchOperationContext((CoreSession)this, searchRequest);
        searchContext.setSyncreplSearch(searchRequest.getControls().containsKey("1.3.6.1.4.1.4203.1.9.1.1"));
        OperationManager operationManager = this.directoryService.getOperationManager();
        SortRequestControl sortControl = (SortRequestControl)searchRequest.getControls().get("1.2.840.113556.1.4.473");
        SortResponseControl sortRespCtrl = null;
        SearchResultDone done = (SearchResultDone)searchRequest.getResultResponse();
        LdapResult ldapResult = done.getLdapResult();
        if (sortControl != null) {
            sortRespCtrl = this.canSort(sortControl, ldapResult, this.getDirectoryService().getSchemaManager());
            if (sortControl.isCritical() && sortRespCtrl.getSortResult() != SortResultCode.SUCCESS) {
                ldapResult.setResultCode(ResultCodeEnum.UNAVAILABLE_CRITICAL_EXTENSION);
                done.addControl(sortRespCtrl);
                return new EmptyCursor<Entry>();
            }
        }
        Cursor<Entry> cursor = null;
        try {
            cursor = operationManager.search(searchContext);
            if (sortRespCtrl != null && sortRespCtrl.getSortResult() == SortResultCode.SUCCESS) {
                cursor = this.sortResults(cursor, sortControl, this.getDirectoryService().getSchemaManager());
            }
            if (sortRespCtrl != null) {
                cursor.beforeFirst();
                if (!cursor.next()) {
                    sortRespCtrl = null;
                } else {
                    cursor.previous();
                }
            }
        }
        catch (LdapException e) {
            done.addAllControls(searchContext.getResponseControls());
            throw e;
        }
        catch (Exception e) {
            done.addAllControls(searchContext.getResponseControls());
            throw new LdapException(e);
        }
        if (sortRespCtrl != null) {
            done.addControl(sortRespCtrl);
        }
        done.addAllControls(searchContext.getResponseControls());
        return cursor;
    }

    @Override
    public void unbind() throws LdapException {
        UnbindOperationContext unbindContext = new UnbindOperationContext(this);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.unbind(unbindContext);
    }

    @Override
    public void unbind(UnbindRequest unbindRequest) throws LdapException {
        UnbindOperationContext unbindContext = new UnbindOperationContext((CoreSession)this, unbindRequest);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.unbind(unbindContext);
    }

    private SortResponseControl canSort(SortRequestControl sortControl, LdapResult ldapResult, SchemaManager schemaManager) {
        SortResponseControlImpl resp = new SortResponseControlImpl();
        List<SortKey> keys = sortControl.getSortKeys();
        if (keys.size() > 1) {
            ldapResult.setDiagnosticMessage("Cannot sort results based on more than one attribute");
            resp.setSortResult(SortResultCode.UNWILLINGTOPERFORM);
            return resp;
        }
        SortKey sk = keys.get(0);
        AttributeType at = schemaManager.getAttributeType(sk.getAttributeTypeDesc());
        if (at == null) {
            ldapResult.setDiagnosticMessage("No attribute with the name " + sk.getAttributeTypeDesc() + " exists in the server's schema");
            resp.setSortResult(SortResultCode.NOSUCHATTRIBUTE);
            resp.setAttributeName(sk.getAttributeTypeDesc());
            return resp;
        }
        String mrOid = sk.getMatchingRuleId();
        if (mrOid != null) {
            MatchingRule mr = at.getOrdering();
            if (mr != null && !mrOid.equals(mr.getOid())) {
                ldapResult.setDiagnosticMessage("Given matchingrule " + mrOid + " is not applicable for the attribute " + sk.getAttributeTypeDesc());
                resp.setSortResult(SortResultCode.INAPPROPRIATEMATCHING);
                resp.setAttributeName(sk.getAttributeTypeDesc());
                return resp;
            }
            try {
                schemaManager.lookupComparatorRegistry(mrOid);
            }
            catch (LdapException e) {
                ldapResult.setDiagnosticMessage("Given matchingrule " + mrOid + " is not supported");
                resp.setSortResult(SortResultCode.INAPPROPRIATEMATCHING);
                resp.setAttributeName(sk.getAttributeTypeDesc());
                return resp;
            }
        }
        MatchingRule mr = at.getOrdering();
        if (mr == null) {
            mr = at.getEquality();
        }
        ldapResult.setDiagnosticMessage("Matchingrule is required for sorting by the attribute " + sk.getAttributeTypeDesc());
        resp.setSortResult(SortResultCode.INAPPROPRIATEMATCHING);
        resp.setAttributeName(sk.getAttributeTypeDesc());
        if (mr == null) {
            return resp;
        }
        try {
            schemaManager.lookupComparatorRegistry(mr.getOid());
        }
        catch (LdapException e) {
            return resp;
        }
        resp.setSortResult(SortResultCode.SUCCESS);
        return resp;
    }

    private Cursor<Entry> sortResults(Cursor<Entry> unsortedEntries, SortRequestControl control, SchemaManager schemaManager) throws CursorException, LdapException, IOException {
        unsortedEntries.beforeFirst();
        Entry first = null;
        if (unsortedEntries.next()) {
            first = unsortedEntries.get();
        }
        if (!unsortedEntries.next()) {
            unsortedEntries.beforeFirst();
            return unsortedEntries;
        }
        SortKey sk = control.getSortKeys().get(0);
        AttributeType at = schemaManager.getAttributeType(sk.getAttributeTypeDesc());
        SortedEntryComparator comparator = new SortedEntryComparator(at, sk.getMatchingRuleId(), sk.isReverseOrder(), schemaManager);
        SortedEntrySerializer keySerializer = new SortedEntrySerializer(comparator);
        PersistedBTreeConfiguration<Entry, String> config = new PersistedBTreeConfiguration<Entry, String>();
        config.setName(UUID.randomUUID().toString());
        config.setKeySerializer(keySerializer);
        config.setValueSerializer(new StringSerializer());
        BTree<Entry, String> btree = BTreeFactory.createPersistedBTree(config);
        File file = File.createTempFile(btree.getName(), ".sorted-data");
        RecordManager recMan = new RecordManager(file.getAbsolutePath());
        try {
            recMan.manage(btree);
        }
        catch (BTreeAlreadyManagedException e) {
            throw new LdapException(e);
        }
        btree.insert(first, null);
        btree.insert(unsortedEntries.get(), null);
        while (unsortedEntries.next()) {
            Entry entry = unsortedEntries.get();
            btree.insert(entry, null);
        }
        unsortedEntries.close();
        return new SortedEntryCursor(btree, recMan, file);
    }
}

