/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.serializer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.mavibot.btree.comparator.LongComparator;
import org.apache.directory.mavibot.btree.exception.SerializerCreationException;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;

public class LongSerializer
extends AbstractElementSerializer<Long> {
    public LongSerializer() {
        super(new LongComparator());
    }

    @Override
    public byte[] serialize(Long element) {
        return LongSerializer.serialize(element);
    }

    public static byte[] serialize(long value) {
        byte[] bytes = new byte[8];
        return LongSerializer.serialize(bytes, 0, value);
    }

    public static byte[] serialize(byte[] buffer, int start, long value) {
        buffer[start] = (byte)(value >>> 56);
        buffer[start + 1] = (byte)(value >>> 48);
        buffer[start + 2] = (byte)(value >>> 40);
        buffer[start + 3] = (byte)(value >>> 32);
        buffer[start + 4] = (byte)(value >>> 24);
        buffer[start + 5] = (byte)(value >>> 16);
        buffer[start + 6] = (byte)(value >>> 8);
        buffer[start + 7] = (byte)value;
        return buffer;
    }

    public static Long deserialize(byte[] in) {
        return LongSerializer.deserialize(in, 0);
    }

    public static Long deserialize(byte[] in, int start) {
        if (in == null || in.length < 8 + start) {
            throw new SerializerCreationException("Cannot extract a Long from a buffer with not enough bytes");
        }
        long result = ((long)in[start] << 56) + (((long)in[start + 1] & 0xFFL) << 48) + (((long)in[start + 2] & 0xFFL) << 40) + (((long)in[start + 3] & 0xFFL) << 32) + (((long)in[start + 4] & 0xFFL) << 24) + (((long)in[start + 5] & 0xFFL) << 16) + (((long)in[start + 6] & 0xFFL) << 8) + ((long)in[start + 7] & 0xFFL);
        return result;
    }

    @Override
    public Long fromBytes(byte[] in) {
        return LongSerializer.deserialize(in, 0);
    }

    @Override
    public Long fromBytes(byte[] in, int start) {
        if (in == null || in.length < 8 + start) {
            throw new SerializerCreationException("Cannot extract a Long from a buffer with not enough bytes");
        }
        long result = ((long)in[start] << 56) + (((long)in[start + 1] & 0xFFL) << 48) + (((long)in[start + 2] & 0xFFL) << 40) + (((long)in[start + 3] & 0xFFL) << 32) + (((long)in[start + 4] & 0xFFL) << 24) + (((long)in[start + 5] & 0xFFL) << 16) + (((long)in[start + 6] & 0xFFL) << 8) + ((long)in[start + 7] & 0xFFL);
        return result;
    }

    @Override
    public Long deserialize(BufferHandler bufferHandler) throws IOException {
        byte[] in = bufferHandler.read(8);
        return LongSerializer.deserialize(in);
    }

    @Override
    public Long deserialize(ByteBuffer buffer) throws IOException {
        return buffer.getLong();
    }
}

