/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.extended.PwdModifyResponse;
import org.apache.directory.api.ldap.extras.extended.PwdModifyResponseImpl;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyResponse;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyResponseDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordModifyResponseDecorator
extends ExtendedResponseDecorator<PwdModifyResponse>
implements PwdModifyResponse {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordModifyResponseDecorator.class);
    private PasswordModifyResponse passwordModifyResponse;

    public PasswordModifyResponseDecorator(LdapApiService codec, PwdModifyResponse decoratedMessage) {
        super(codec, decoratedMessage);
        this.passwordModifyResponse = new PasswordModifyResponse(decoratedMessage);
    }

    public PasswordModifyResponse getPasswordModifyResponse() {
        return this.passwordModifyResponse;
    }

    @Override
    public void setResponseValue(byte[] responseValue) {
        PasswordModifyResponseDecoder decoder = new PasswordModifyResponseDecoder();
        try {
            this.passwordModifyResponse = (PasswordModifyResponse)decoder.decode(responseValue);
            ((PwdModifyResponseImpl)this.getDecorated()).setGenPassword(this.passwordModifyResponse.getPwdModifyResponse().getGenPassword());
            if (responseValue != null) {
                this.responseValue = new byte[responseValue.length];
                System.arraycopy(responseValue, 0, this.responseValue, 0, responseValue.length);
            } else {
                this.responseValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err(I18n.ERR_04165, new Object[0]), e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getResponseValue() {
        if (this.responseValue == null) {
            try {
                this.responseValue = this.passwordModifyResponse.encode().array();
                if (this.responseValue == null) {
                    return null;
                }
            }
            catch (EncoderException e) {
                LOG.error(I18n.err(I18n.ERR_04167, new Object[0]), e);
                throw new RuntimeException(e);
            }
        }
        byte[] copy = new byte[this.responseValue.length];
        System.arraycopy(this.responseValue, 0, copy, 0, this.responseValue.length);
        return copy;
    }

    @Override
    public byte[] getGenPassword() {
        return ((PwdModifyResponse)this.getDecorated()).getGenPassword();
    }

    public void setGenPassword(byte[] genPassword) {
        ((PwdModifyResponseImpl)this.getDecorated()).setGenPassword(genPassword);
    }

    @Override
    public String getResponseName() {
        return null;
    }
}

