/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotDnIndex;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotEntrySerializer;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotIndex;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotMasterTable;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotRdnIndex;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.DefaultOptimizer;
import org.apache.directory.server.xdbm.search.impl.DefaultSearchEngine;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.server.xdbm.search.impl.NoOpOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotPartition
extends AbstractBTreePartition {
    private static final Logger LOG = LoggerFactory.getLogger(MavibotPartition.class);
    private static final String MAVIBOT_DB_FILE_EXTN = ".data";
    private static final FilenameFilter DB_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(MavibotPartition.MAVIBOT_DB_FILE_EXTN) && !name.startsWith("master.");
        }
    };
    private RecordManager recordMan;

    public MavibotPartition(SchemaManager schemaManager) {
        super(schemaManager);
        MavibotEntrySerializer.setSchemaManager(schemaManager);
        if (this.cacheSize < 0) {
            this.cacheSize = 10000;
            LOG.debug("Using the default entry cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
        } else {
            LOG.debug("Using the custom configured cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
        }
    }

    @Override
    protected void doInit() throws Exception {
        if (!this.initialized) {
            if (!this.isOptimizerEnabled()) {
                this.setOptimizer(new NoOpOptimizer());
            } else {
                this.setOptimizer(new DefaultOptimizer(this));
            }
            EvaluatorBuilder evaluatorBuilder = new EvaluatorBuilder(this, this.schemaManager);
            CursorBuilder cursorBuilder = new CursorBuilder(this, evaluatorBuilder);
            this.setSearchEngine(new DefaultSearchEngine(this, cursorBuilder, evaluatorBuilder, this.getOptimizer()));
            File partitionDir = new File(this.getPartitionPath());
            if (!partitionDir.exists() && !partitionDir.mkdirs()) {
                throw new IOException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, partitionDir));
            }
            this.recordMan = new RecordManager(partitionDir.getPath());
            super.doInit();
            this.master = new MavibotMasterTable(this.recordMan, this.schemaManager, "master");
            File[] allIndexDbFiles = partitionDir.listFiles(DB_FILTER);
            List<String> indexDbFileNameList = Arrays.asList(partitionDir.list(DB_FILTER));
            ArrayList<String> allIndices = new ArrayList<String>();
            for (Index index : this.systemIndices.values()) {
                allIndices.add(index.getAttribute().getOid());
            }
            ArrayList indexToBuild = new ArrayList();
            this.initialized = true;
        }
    }

    @Override
    protected Index<?, Entry, String> convertAndInit(Index<?, Entry, String> index) throws Exception {
        MavibotIndex mavibotIndex;
        if (index instanceof MavibotRdnIndex) {
            mavibotIndex = (MavibotRdnIndex)index;
        } else if (index instanceof MavibotDnIndex) {
            mavibotIndex = (MavibotDnIndex)index;
        } else if (index instanceof MavibotIndex) {
            mavibotIndex = (MavibotIndex)index;
            if (mavibotIndex.getWkDirPath() == null) {
                mavibotIndex.setWkDirPath(this.partitionPath);
            }
        } else {
            LOG.debug("Supplied index {} is not a MavibotIndex.  Will create new MavibotIndex using copied configuration parameters.", (Object)index);
            mavibotIndex = new MavibotIndex(this.recordMan, index.getAttributeId(), true);
            mavibotIndex.setCacheSize(index.getCacheSize());
            mavibotIndex.setWkDirPath(index.getWkDirPath());
        }
        mavibotIndex.recordMan = this.recordMan;
        mavibotIndex.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId()));
        return mavibotIndex;
    }

    @Override
    protected Index createSystemIndex(String indexOid, URI path, boolean withReverse) throws Exception {
        MavibotIndex mavibotIndex;
        LOG.debug("Supplied index {} is not a MavibotIndex.  Will create new MavibotIndex using copied configuration parameters.");
        if (indexOid.equals("1.3.6.1.4.1.18060.0.4.1.2.50")) {
            mavibotIndex = new MavibotRdnIndex(this.recordMan);
            mavibotIndex.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.50");
        } else if (indexOid.equals("1.3.6.1.4.1.18060.0.4.1.2.7")) {
            mavibotIndex = new MavibotDnIndex(this.recordMan, "1.3.6.1.4.1.18060.0.4.1.2.7");
            mavibotIndex.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.7");
        } else {
            mavibotIndex = new MavibotIndex(this.recordMan, indexOid, withReverse);
        }
        mavibotIndex.setWkDirPath(path);
        return mavibotIndex;
    }

    @Override
    public void sync() throws Exception {
        if (!this.initialized) {
            return;
        }
        for (Index idx : this.systemIndices.values()) {
            idx.sync();
        }
        for (Index idx : this.userIndices.values()) {
            idx.sync();
        }
        ((MavibotMasterTable)this.master).sync();
    }

    private void deleteUnusedIndexFiles(List<String> allIndices, File[] dbFiles) {
    }

    private void buildUserIndex(List<Index<?, Entry, String>> userIndexes) throws Exception {
        Cursor cursor = this.master.cursor();
        cursor.beforeFirst();
        while (cursor.next()) {
            for (Index<?, Entry, String> index : userIndexes) {
                AttributeType atType = index.getAttribute();
                String attributeOid = index.getAttribute().getOid();
                LOG.info("building the index for attribute type {}", (Object)atType);
                Tuple tuple = cursor.get();
                String id = (String)tuple.getKey();
                Entry entry = (Entry)tuple.getValue();
                Attribute entryAttr = entry.get(atType);
                if (entryAttr == null) continue;
                for (Value value : entryAttr) {
                    index.add(value.getValue(), id);
                }
                this.presenceIdx.add(attributeOid, id);
            }
        }
        cursor.close();
    }

    public String getDefaultId() {
        return Partition.DEFAULT_ID;
    }

    public String getRootId() {
        return Partition.ROOT_ID;
    }

    public RecordManager getRecordMan() {
        return this.recordMan;
    }
}

