/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapEncoder;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.SearchResultReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultReferenceDecorator
extends MessageDecorator<SearchResultReference>
implements SearchResultReference {
    private int referralLength;
    private int searchResultReferenceLength;

    public SearchResultReferenceDecorator(LdapApiService codec, SearchResultReference decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public int getReferralLength() {
        return this.referralLength;
    }

    public void setReferralLength(int referralLength) {
        this.referralLength = referralLength;
    }

    public int getSearchResultReferenceLength() {
        return this.searchResultReferenceLength;
    }

    public void setSearchResultReferenceLength(int searchResultReferenceLength) {
        this.searchResultReferenceLength = searchResultReferenceLength;
    }

    @Override
    public Referral getReferral() {
        return ((SearchResultReference)this.getDecorated()).getReferral();
    }

    @Override
    public void setReferral(Referral referral) {
        ((SearchResultReference)this.getDecorated()).setReferral(referral);
    }

    @Override
    public int computeLength() {
        int searchResultReferenceLength = 0;
        Referral referral = this.getReferral();
        int referralLength = LdapEncoder.computeReferralLength(referral);
        if (referralLength != 0) {
            this.setReferral(referral);
            searchResultReferenceLength = referralLength;
        }
        this.setSearchResultReferenceLength(searchResultReferenceLength);
        return 1 + TLV.getNbBytes(searchResultReferenceLength) + searchResultReferenceLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        SearchResultReference searchResultReference = (SearchResultReference)this.getDecorated();
        try {
            buffer.put((byte)115);
            buffer.put(TLV.getBytes(this.getSearchResultReferenceLength()));
            Referral referral = searchResultReference.getReferral();
            if (referral != null) {
                for (byte[] ldapUrlBytes : referral.getLdapUrlsBytes()) {
                    BerValue.encode(buffer, ldapUrlBytes);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }
}

