/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.addRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.codec.decorators.AddRequestDecorator;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.AddResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreAddRequestEntryName
extends GrammarAction<LdapMessageContainer<AddRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreAddRequestEntryName.class);

    public StoreAddRequestEntryName() {
        super("Store Add request entry Name");
    }

    @Override
    public void action(LdapMessageContainer<AddRequestDecorator> container) throws DecoderException {
        AddRequestDecorator addRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_04085, new Object[0]);
            LOG.error(msg);
            AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
            throw new ResponseCarryingException(msg, response, ResultCodeEnum.NAMING_VIOLATION, Dn.EMPTY_DN, null);
        }
        Dn entryDn = null;
        byte[] dnBytes = tlv.getValue().getData();
        String dnStr = Strings.utf8ToString(dnBytes);
        try {
            entryDn = new Dn(dnStr);
        }
        catch (LdapInvalidDnException ine) {
            String msg = "Invalid Dn given : " + dnStr + " (" + Strings.dumpBytes(dnBytes) + ") is invalid";
            LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
            AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
            throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
        }
        addRequest.setEntryDn(entryDn);
        LOG.debug("Adding an entry with Dn : {}", (Object)addRequest.getEntry());
    }
}

