/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries.helper;

import java.util.List;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingRuleUseHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MatchingRuleUseHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRegistries(MatchingRuleUse matchingRuleUse, List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null) {
            try {
                matchingRuleUse.unlock();
                AttributeTypeRegistry atRegistry = registries.getAttributeTypeRegistry();
                matchingRuleUse.getApplicableAttributes().clear();
                for (String oid : matchingRuleUse.getApplicableAttributeOids()) {
                    matchingRuleUse.getApplicableAttributes().add((AttributeType)atRegistry.lookup(oid));
                }
            }
            finally {
                matchingRuleUse.lock();
            }
        }
    }
}

