/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.io.IOException;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonIndexCursor<V>
extends AbstractIndexCursor<V> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private boolean beforeFirst = true;
    private boolean afterLast;
    private boolean onSingleton;
    private final IndexEntry<V, String> singleton;

    public SingletonIndexCursor(IndexEntry<V, String> singleton) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating SingletonIndexCursor {}", (Object)this);
        }
        this.singleton = singleton;
    }

    @Override
    protected String getUnsupportedMessage() {
        return "Unsupported operation";
    }

    @Override
    public boolean available() {
        return this.onSingleton;
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("()");
        this.beforeFirst = true;
        this.afterLast = false;
        this.onSingleton = false;
    }

    @Override
    public void afterLast() throws LdapException, CursorException, IOException {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.afterLast = true;
        this.onSingleton = false;
    }

    @Override
    public boolean first() throws LdapException, CursorException, IOException {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    @Override
    public boolean last() throws LdapException, CursorException, IOException {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    @Override
    public boolean isFirst() {
        return this.onSingleton;
    }

    @Override
    public boolean isLast() {
        return this.onSingleton;
    }

    @Override
    public boolean isAfterLast() {
        return this.afterLast;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.beforeFirst;
    }

    @Override
    public boolean previous() throws LdapException, CursorException, IOException {
        this.checkNotClosed("()");
        if (this.beforeFirst) {
            return false;
        }
        if (this.afterLast) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        this.beforeFirst = true;
        this.onSingleton = false;
        this.afterLast = false;
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException, IOException {
        this.checkNotClosed("()");
        if (this.beforeFirst) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        if (this.afterLast) {
            return false;
        }
        this.beforeFirst = false;
        this.onSingleton = false;
        this.afterLast = true;
        return false;
    }

    @Override
    public IndexEntry<V, String> get() throws CursorException, IOException {
        this.checkNotClosed("()");
        if (this.onSingleton) {
            return this.singleton;
        }
        if (this.beforeFirst) {
            throw new InvalidCursorPositionException(I18n.err(I18n.ERR_705, new Object[0]));
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_706, new Object[0]));
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing SingletonIndexCursor {}", (Object)this);
        }
        super.close();
    }

    @Override
    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing SingletonIndexCursor {}", (Object)this);
        }
        super.close(cause);
    }
}

