/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSAQualitySyntaxSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(DSAQualitySyntaxSyntaxChecker.class);

    public DSAQualitySyntaxSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.19");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() < 7) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        String remaining = null;
        switch (strValue.charAt(0)) {
            case 'B': {
                if (!strValue.startsWith("BEST-EFFORT")) {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
                remaining = strValue.substring("BEST-EFFORT".length());
                break;
            }
            case 'D': {
                if (!strValue.startsWith("DEFUNCT")) {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
                remaining = strValue.substring("DEFUNCT".length());
                break;
            }
            case 'E': {
                if (!strValue.startsWith("EXPERIMENTAL")) {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
                remaining = strValue.substring("EXPERIMENTAL".length());
                break;
            }
            case 'F': {
                if (!strValue.startsWith("FULL-SERVICE")) {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
                remaining = strValue.substring("FULL-SERVICE".length());
                break;
            }
            case 'P': {
                if (!strValue.startsWith("PILOT-SERVICE")) {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
                remaining = strValue.substring("PILOT-SERVICE".length());
                break;
            }
            default: {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
        }
        if (remaining.length() == 0) {
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        if (remaining.charAt(0) != '#') {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        boolean result = Strings.isPrintableString(remaining.substring(1));
        if (result) {
            LOG.debug("Syntax valid for '{}'", value);
        } else {
            LOG.debug("Syntax invalid for '{}'", value);
        }
        return result;
    }
}

