/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.comparators;

import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayComparator
extends LdapComparator<byte[]> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(ByteArrayComparator.class);

    public ByteArrayComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(byte[] b1, byte[] b2) {
        LOG.debug("comparing OctetString objects '{}' with '{}'", (Object)Strings.dumpBytes(b1), (Object)Strings.dumpBytes(b2));
        if (b1 == null) {
            return b2 == null ? 0 : -1;
        }
        if (b2 == null) {
            return 1;
        }
        if (b1.length == b2.length) {
            for (int i = 0; i < b1.length; ++i) {
                if (b1[i] > b2[i]) {
                    return 1;
                }
                if (b1[i] >= b2[i]) continue;
                return -1;
            }
            return 0;
        }
        int minLength = Math.min(b1.length, b2.length);
        for (int i = 0; i < minLength; ++i) {
            if (b1[i] > b2[i]) {
                return 1;
            }
            if (b1[i] >= b2[i]) continue;
            return -1;
        }
        if (b1.length == minLength) {
            return -1;
        }
        if (b2.length == minLength) {
            return 1;
        }
        return 0;
    }
}

