/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.krbPriv.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.krbPriv.KrbPrivContainer;
import org.apache.directory.shared.kerberos.messages.KrbPriv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KrbPrivInit
extends GrammarAction<KrbPrivContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(KrbPrivInit.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public KrbPrivInit() {
        super("Creates a KrbPriv instance");
    }

    @Override
    public void action(KrbPrivContainer krbPrivContainer) throws DecoderException {
        TLV tlv = krbPrivContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err(I18n.ERR_04066, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_04067, new Object[0]));
        }
        KrbPriv krbPriv = new KrbPriv();
        krbPrivContainer.setKrbPriv(krbPriv);
        if (IS_DEBUG) {
            LOG.debug("KrbPriv created");
        }
    }
}

