/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ntp.protocol;

import org.apache.directory.server.ntp.NtpService;
import org.apache.directory.server.ntp.messages.NtpMessage;
import org.apache.directory.server.ntp.service.NtpServiceImpl;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtpProtocolHandler
extends IoHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(NtpProtocolHandler.class);
    private NtpService ntpService = new NtpServiceImpl();

    public void exceptionCaught(IoSession session, Throwable cause) {
        log.error(session.getRemoteAddress() + " EXCEPTION", cause);
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) {
        if (log.isDebugEnabled()) {
            log.debug("{} RCVD:  {}", session.getRemoteAddress(), message);
        }
        NtpMessage reply = this.ntpService.getReplyFor((NtpMessage)message);
        session.write(reply);
    }
}

