/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapCoreSessionConnection;
import org.apache.directory.server.core.event.EventType;
import org.apache.directory.server.core.event.NotificationCriteria;
import org.apache.directory.server.ldap.replication.ReplicaEventLog;
import org.apache.directory.shared.ldap.model.cursor.EntryCursor;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicaDitStoreUtil {
    private CoreSession adminSession;
    private SchemaManager schemaManager;
    private static final String REPL_CONSUMER_DN = "ou=consumers,ou=system";
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaDitStoreUtil.class);
    private Map<Integer, List<Modification>> modMap = new HashMap<Integer, List<Modification>>();
    private LdapCoreSessionConnection coreConnection;

    public ReplicaDitStoreUtil(DirectoryService dirService) throws Exception {
        this.adminSession = dirService.getAdminSession();
        this.schemaManager = dirService.getSchemaManager();
        this.coreConnection = new LdapCoreSessionConnection(this.adminSession);
        this.init();
    }

    private void init() throws Exception {
        Dn replConsumerDn = new Dn(this.schemaManager, REPL_CONSUMER_DN);
        if (!this.adminSession.exists(replConsumerDn)) {
            LOG.debug("creating the entry for storing replication consumers' details");
            DefaultEntry entry = new DefaultEntry(this.schemaManager);
            entry.setDn(replConsumerDn);
            entry.add("objectClass", "organizationalUnit");
            entry.add("ou", "consumers");
            this.adminSession.add(entry);
        }
    }

    public void addConsumerEntry(ReplicaEventLog replica) throws Exception {
        if (replica == null) {
            return;
        }
        DefaultEntry entry = new DefaultEntry(this.schemaManager);
        entry.setDn(new Dn(this.schemaManager, "ads-dsReplicaId=" + replica.getId() + "," + REPL_CONSUMER_DN));
        entry.add("objectClass", "ads-replEventLog");
        entry.add("ads-dsReplicaId", String.valueOf(replica.getId()));
        entry.add("ads-replAliasDerefMode", replica.getSearchCriteria().getAliasDerefMode().getJndiValue());
        entry.add("ads-searchBaseDN", replica.getSearchCriteria().getBase().getName());
        entry.add("ads-replLastSentCsn", replica.getLastSentCsn());
        entry.add("ads-replSearchScope", replica.getSearchCriteria().getScope().getLdapUrlValue());
        entry.add("ads-replRefreshNPersist", String.valueOf(replica.isRefreshNPersist()));
        entry.add("ads-replSearchFilter", replica.getSearchFilter());
        this.adminSession.add(entry);
        LOG.debug("stored replication consumer entry {}", entry.getDn());
    }

    public void updateReplicaLastSentCsn(ReplicaEventLog replica) throws Exception {
        List<Modification> mods = this.modMap.get(replica.getId());
        Attribute lastSentCsnAt = null;
        if (mods == null) {
            lastSentCsnAt = new DefaultAttribute(this.schemaManager.lookupAttributeTypeRegistry("ads-replLastSentCsn"));
            lastSentCsnAt.add(replica.getLastSentCsn());
            DefaultModification mod = new DefaultModification();
            mod.setOperation(ModificationOperation.REPLACE_ATTRIBUTE);
            mod.setAttribute(lastSentCsnAt);
            mods = new ArrayList<Modification>(1);
            mods.add(mod);
        } else {
            lastSentCsnAt = mods.get(0).getAttribute();
            lastSentCsnAt.clear();
            lastSentCsnAt.add(replica.getLastSentCsn());
        }
        Dn dn = new Dn(this.schemaManager, "ads-dsReplicaId=" + replica.getId() + "," + REPL_CONSUMER_DN);
        this.adminSession.modify(dn, mods);
        LOG.debug("updated last sent CSN of consumer entry {}", dn);
    }

    public List<ReplicaEventLog> getReplicaEventLogs() throws Exception {
        ArrayList<ReplicaEventLog> replicas = new ArrayList<ReplicaEventLog>();
        EntryCursor cursor = this.coreConnection.search(REPL_CONSUMER_DN, "(objectClass=ads-replEventLog)", SearchScope.ONELEVEL, "+", "*");
        while (cursor.next()) {
            Entry entry = (Entry)cursor.get();
            ReplicaEventLog replica = this.convertEntryToReplica(entry);
            replicas.add(replica);
        }
        cursor.close();
        return replicas;
    }

    private ReplicaEventLog convertEntryToReplica(Entry entry) throws Exception {
        String id = entry.get("ads-dsReplicaId").getString();
        ReplicaEventLog replica = new ReplicaEventLog(Integer.parseInt(id));
        NotificationCriteria searchCriteria = new NotificationCriteria();
        String aliasMode = entry.get("ads-replAliasDerefMode").getString();
        searchCriteria.setAliasDerefMode(AliasDerefMode.getDerefMode(aliasMode));
        String baseDn = entry.get("ads-searchBaseDN").getString();
        searchCriteria.setBase(new Dn(this.schemaManager, baseDn));
        Attribute lastSentCsnAt = entry.get("ads-replLastSentCsn");
        if (lastSentCsnAt != null) {
            replica.setLastSentCsn(lastSentCsnAt.getString());
        }
        String scope = entry.get("ads-replSearchScope").getString();
        int scopeIntVal = SearchScope.getSearchScope(scope);
        searchCriteria.setScope(SearchScope.getSearchScope(scopeIntVal));
        String filter = entry.get("ads-replSearchFilter").getString();
        searchCriteria.setFilter(filter);
        replica.setSearchFilter(filter);
        replica.setRefreshNPersist(Boolean.parseBoolean(entry.get("ads-replRefreshNPersist").getString()));
        searchCriteria.setEventMask(EventType.ALL_EVENT_TYPES_MASK);
        replica.setSearchCriteria(searchCriteria);
        replica.setDirty(false);
        return replica;
    }
}

