/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.digestMD5;

import java.util.HashMap;
import java.util.Map;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.digestMD5.DigestMd5CallbackHandler;
import org.apache.directory.shared.ldap.model.message.BindRequest;

public class DigestMd5MechanismHandler
extends AbstractMechanismHandler {
    private String getActiveRealms(LdapServer ldapServer) {
        StringBuilder realms = new StringBuilder();
        boolean isFirst = true;
        for (String realm : ldapServer.getSaslRealms()) {
            if (isFirst) {
                isFirst = false;
            } else {
                realms.append(' ');
            }
            realms.append(realm);
        }
        return realms.toString();
    }

    public SaslServer handleMechanism(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        SaslServer ss = (SaslServer)ldapSession.getSaslProperty("saslServer");
        if (ss == null) {
            CoreSession adminSession = ldapSession.getLdapServer().getDirectoryService().getAdminSession();
            DigestMd5CallbackHandler callbackHandler = new DigestMd5CallbackHandler(ldapSession, adminSession, bindRequest);
            ss = Sasl.createSaslServer("DIGEST-MD5", "ldap", (String)ldapSession.getSaslProperty("host"), (Map)ldapSession.getSaslProperty("saslProps"), callbackHandler);
            ldapSession.putSaslProperty("saslServer", ss);
        }
        return ss;
    }

    public void init(LdapSession ldapSession) {
        String saslHost = ldapSession.getLdapServer().getSaslHost();
        String userBaseDn = ldapSession.getLdapServer().getSearchBaseDn();
        ldapSession.putSaslProperty("host", saslHost);
        ldapSession.putSaslProperty("userBaseDn", userBaseDn);
        HashMap<String, String> saslProps = new HashMap<String, String>();
        saslProps.put("javax.security.sasl.qop", ldapSession.getLdapServer().getSaslQopString());
        saslProps.put("com.sun.security.sasl.digest.realm", this.getActiveRealms(ldapSession.getLdapServer()));
        ldapSession.putSaslProperty("saslProps", saslProps);
    }

    public void cleanup(LdapSession ldapSession) {
        this.insertSaslFilter(ldapSession);
        ldapSession.removeSaslProperty("host");
        ldapSession.removeSaslProperty("userBaseDn");
        ldapSession.removeSaslProperty("saslMech");
        ldapSession.removeSaslProperty("saslProps");
        ldapSession.removeSaslProperty("saslAuthentUser");
    }
}

