/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.model.message.UnbindRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnbindHandler
extends LdapRequestHandler<UnbindRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(UnbindHandler.class);

    @Override
    public void handle(LdapSession session, UnbindRequest unbindRequest) throws Exception {
        LOG.debug("Received: {}", unbindRequest);
        try {
            session.getCoreSession().unbind(unbindRequest);
            session.getIoSession().close(true);
            this.ldapServer.getLdapSessionManager().removeLdapSession(session.getIoSession());
        }
        catch (Throwable t) {
            LOG.error(I18n.err(I18n.ERR_169, new Object[0]), t);
        }
    }
}

