/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.controls.PagedSearchContext;
import org.apache.directory.shared.ldap.model.message.AbandonableRequest;
import org.apache.directory.shared.ldap.model.message.BindStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapSession {
    private static final Logger LOG = LoggerFactory.getLogger(LdapSession.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final AbandonableRequest[] EMPTY_ABANDONABLES = new AbandonableRequest[0];
    private final String outstandingLock;
    private final IoSession ioSession;
    private CoreSession coreSession;
    private LdapServer ldapServer;
    private Map<Integer, AbandonableRequest> outstandingRequests;
    private BindStatus bindStatus;
    private String currentMechanism;
    private Map<String, Object> saslProperties;
    private Map<Integer, PagedSearchContext> pagedSearchContexts;

    public LdapSession(IoSession ioSession) {
        this.ioSession = ioSession;
        this.outstandingLock = "OutstandingRequestLock: " + ioSession.toString();
        this.outstandingRequests = new ConcurrentHashMap<Integer, AbandonableRequest>();
        this.bindStatus = BindStatus.ANONYMOUS;
        this.saslProperties = new HashMap<String, Object>();
        this.pagedSearchContexts = new ConcurrentHashMap<Integer, PagedSearchContext>();
    }

    public boolean isAuthenticated() {
        return this.coreSession != null && this.bindStatus == BindStatus.AUTHENTICATED;
    }

    public boolean isAnonymous() {
        return this.bindStatus == BindStatus.ANONYMOUS;
    }

    public boolean isAuthPending() {
        return this.bindStatus == BindStatus.SIMPLE_AUTH_PENDING || this.bindStatus == BindStatus.SASL_AUTH_PENDING;
    }

    public boolean isSimpleAuthPending() {
        return this.bindStatus == BindStatus.SIMPLE_AUTH_PENDING;
    }

    public boolean isSaslAuthPending() {
        return this.bindStatus == BindStatus.SASL_AUTH_PENDING;
    }

    public IoSession getIoSession() {
        return this.ioSession;
    }

    public CoreSession getCoreSession() {
        return this.coreSession;
    }

    public void setCoreSession(CoreSession coreSession) {
        this.coreSession = coreSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abandonAllOutstandingRequests() {
        String string = this.outstandingLock;
        synchronized (string) {
            AbandonableRequest[] abandonables;
            for (AbandonableRequest abandonable : abandonables = this.outstandingRequests.values().toArray(EMPTY_ABANDONABLES)) {
                this.abandonOutstandingRequest(abandonable.getMessageId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbandonableRequest abandonOutstandingRequest(int messageId) {
        AbandonableRequest request = null;
        String string = this.outstandingLock;
        synchronized (string) {
            request = this.outstandingRequests.remove(messageId);
        }
        if (request == null) {
            LOG.warn("AbandonableRequest with messageId {} not found in outstandingRequests.", messageId);
            return null;
        }
        if (request.isAbandoned()) {
            LOG.info("AbandonableRequest with messageId {} has already been abandoned", messageId);
            return request;
        }
        request.abandon();
        if (IS_DEBUG) {
            LOG.debug("AbandonRequest on AbandonableRequest wth messageId {} was successful.", messageId);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutstandingRequest(AbandonableRequest request) {
        String string = this.outstandingLock;
        synchronized (string) {
            this.outstandingRequests.put(request.getMessageId(), request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOutstandingRequest(AbandonableRequest request) {
        String string = this.outstandingLock;
        synchronized (string) {
            this.outstandingRequests.remove(request.getMessageId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, AbandonableRequest> getOutstandingRequests() {
        String string = this.outstandingLock;
        synchronized (string) {
            return Collections.unmodifiableMap(this.outstandingRequests);
        }
    }

    public BindStatus getBindStatus() {
        return this.bindStatus;
    }

    public void setSimpleAuthPending() {
        this.bindStatus = BindStatus.SIMPLE_AUTH_PENDING;
    }

    public void setSaslAuthPending() {
        this.bindStatus = BindStatus.SASL_AUTH_PENDING;
    }

    public void setAnonymous() {
        this.bindStatus = BindStatus.ANONYMOUS;
    }

    public void setAuthenticated() {
        this.bindStatus = BindStatus.AUTHENTICATED;
    }

    public String getCurrentMechanism() {
        return this.currentMechanism;
    }

    public void putSaslProperty(String property, Object value) {
        this.saslProperties.put(property, value);
    }

    public Object getSaslProperty(String property) {
        return this.saslProperties.get(property);
    }

    public void clearSaslProperties() {
        this.saslProperties.clear();
    }

    public void removeSaslProperty(String property) {
        this.saslProperties.remove(property);
    }

    public LdapServer getLdapServer() {
        return this.ldapServer;
    }

    public void setLdapServer(LdapServer ldapServer) {
        this.ldapServer = ldapServer;
    }

    public void addPagedSearchContext(PagedSearchContext context) throws Exception {
        EntryFilteringCursor cursor;
        PagedSearchContext oldContext = this.pagedSearchContexts.put(context.getCookieValue(), context);
        if (oldContext != null && (cursor = oldContext.getCursor()) != null) {
            try {
                cursor.close();
            }
            catch (Exception e) {
                LOG.error(I18n.err(I18n.ERR_172, e.getLocalizedMessage()));
            }
        }
    }

    public PagedSearchContext removePagedSearchContext(int contextId) {
        return this.pagedSearchContexts.remove(contextId);
    }

    public PagedSearchContext getPagedSearchContext(int contextId) {
        PagedSearchContext ctx = this.pagedSearchContexts.get(contextId);
        return ctx;
    }

    public String toString() {
        if (this.coreSession == null) {
            return "LdapSession : No Ldap session ...";
        }
        StringBuilder sb = new StringBuilder();
        LdapPrincipal principal = this.coreSession.getAuthenticatedPrincipal();
        SocketAddress address = this.coreSession.getClientAddress();
        sb.append("LdapSession : <");
        if (principal != null) {
            sb.append(principal.getName());
            sb.append(",");
        }
        if (address != null) {
            sb.append(address);
        } else {
            sb.append("...");
        }
        sb.append(">");
        return sb.toString();
    }
}

