/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.keytab;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.mina.core.buffer.IoBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeytabDecoder {
    KeytabDecoder() {
    }

    byte[] getKeytabVersion(IoBuffer buffer) {
        byte[] version = new byte[2];
        buffer.get(version);
        return version;
    }

    List<KeytabEntry> getKeytabEntries(IoBuffer buffer) {
        ArrayList<KeytabEntry> entries = new ArrayList<KeytabEntry>();
        while (buffer.remaining() > 0) {
            int size = buffer.getInt();
            byte[] entry = new byte[size];
            buffer.get(entry);
            entries.add(this.getKeytabEntry(IoBuffer.wrap(entry)));
        }
        return entries;
    }

    private KeytabEntry getKeytabEntry(IoBuffer buffer) {
        String principalName = this.getPrincipalName(buffer);
        long principalType = buffer.getUnsignedInt();
        long time = buffer.getUnsignedInt();
        KerberosTime timeStamp = new KerberosTime(time * 1000L);
        byte keyVersion = buffer.get();
        EncryptionKey key = this.getKeyBlock(buffer);
        return new KeytabEntry(principalName, principalType, timeStamp, keyVersion, key);
    }

    private String getPrincipalName(IoBuffer buffer) {
        int count = buffer.getUnsignedShort();
        String realm = this.getCountedString(buffer);
        StringBuffer principalNameBuffer = new StringBuffer();
        for (int ii = 0; ii < count; ++ii) {
            String nameComponent = this.getCountedString(buffer);
            principalNameBuffer.append(nameComponent);
            if (ii >= count - 1) continue;
            principalNameBuffer.append("\\");
        }
        principalNameBuffer.append("@" + realm);
        return principalNameBuffer.toString();
    }

    private EncryptionKey getKeyBlock(IoBuffer buffer) {
        int type = buffer.getUnsignedShort();
        byte[] keyblock = this.getCountedBytes(buffer);
        EncryptionType encryptionType = EncryptionType.getTypeByValue(type);
        EncryptionKey key = new EncryptionKey(encryptionType, keyblock);
        return key;
    }

    private String getCountedString(IoBuffer buffer) {
        int length = buffer.getUnsignedShort();
        byte[] data = new byte[length];
        buffer.get(data);
        try {
            return new String(data, "ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            return "";
        }
    }

    private byte[] getCountedBytes(IoBuffer buffer) {
        int length = buffer.getUnsignedShort();
        byte[] data = new byte[length];
        buffer.get(data);
        return data;
    }
}

