/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.registries.synchronizers;

import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.schema.registries.synchronizers.AbstractRegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectClassSynchronizer
extends AbstractRegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectClassSynchronizer.class);

    public ObjectClassSynchronizer(SchemaManager schemaManager) throws Exception {
        super(schemaManager);
    }

    public boolean modify(ModifyOperationContext modifyContext, Entry targetEntry, boolean cascade) throws LdapException {
        Dn name = modifyContext.getDn();
        Entry entry = modifyContext.getEntry();
        String oid = this.getOid(entry);
        ObjectClass oc = this.factory.getObjectClass(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), this.getSchemaName(name));
        String schemaName = this.getSchemaName(entry.getDn());
        if (this.isSchemaEnabled(schemaName)) {
            this.schemaManager.unregisterObjectClass(oid);
            this.schemaManager.add(oc);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void add(Entry entry) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "ObjectCLass");
        this.checkOidIsUnique(entry);
        String schemaName = this.getSchemaName(dn);
        ObjectClass objectClass = this.factory.getObjectClass(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isEnabled() && objectClass.isEnabled()) {
            if (this.schemaManager.add(objectClass)) {
                LOG.debug("Added {} into the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_373, entry.getDn().getName(), Strings.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("The ObjectClass {} cannot be added in the disabled schema {}.", objectClass, (Object)schemaName);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void delete(Entry entry, boolean cascade) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "ObjectCLass");
        String schemaName = this.getSchemaName(entry.getDn());
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isDisabled()) {
            LOG.debug("The ObjectClass {} cannot be removed from the disabled schema {}.", (Object)dn.getName(), (Object)schemaName);
            return;
        }
        ObjectClass objectClass = (ObjectClass)this.checkOidExists(entry);
        if (schema.isEnabled() && objectClass.isEnabled()) {
            if (this.schemaManager.delete(objectClass)) {
                LOG.debug("Removed {} from the schema {}", objectClass, (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_374, entry.getDn().getName(), Strings.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("Removed {} from the disabled schema {}", objectClass, (Object)schemaName);
    }

    public void rename(Entry entry, Rdn newRdn, boolean cascade) throws LdapException {
        String schemaName = this.getSchemaName(entry.getDn());
        ObjectClass oldOc = this.factory.getObjectClass(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Entry targetEntry = entry.clone();
        String newOid = newRdn.getNormValue().getString();
        targetEntry.put("m-oid", newOid);
        Dn newDn = targetEntry.getDn().getParent();
        newDn = newDn.add(newRdn);
        this.checkOidIsUnique(newOid);
        ObjectClass oc = this.factory.getObjectClass(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        if (this.isSchemaEnabled(schemaName)) {
            if (this.schemaManager.getObjectClassRegistry().hasDescendants(oldOc.getOid())) {
                String msg = I18n.err(I18n.ERR_375, entry.getDn().getName(), newDn);
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            }
            this.schemaManager.unregisterObjectClass(oldOc.getOid());
            this.schemaManager.add(oc);
        } else {
            this.unregisterOids(oldOc);
            this.registerOids(oc);
        }
    }

    public void moveAndRename(Dn oriChildName, Dn newParentName, Rdn newRdn, boolean deleteOldRn, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oldSchemaName = this.getSchemaName(oriChildName);
        ObjectClass oldOc = this.factory.getObjectClass(this.schemaManager, entry, this.schemaManager.getRegistries(), oldSchemaName);
        String newSchemaName = this.getSchemaName(newParentName);
        Entry targetEntry = entry.clone();
        String newOid = newRdn.getNormValue().getString();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", newOid);
        ObjectClass oc = this.factory.getObjectClass(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterObjectClass(oldOc.getOid());
        } else {
            this.unregisterOids(oldOc);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(oc);
        } else {
            this.registerOids(oc);
        }
    }

    public void move(Dn oriChildName, Dn newParentName, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        ObjectClass oldAt = this.factory.getObjectClass(this.schemaManager, entry, this.schemaManager.getRegistries(), oldSchemaName);
        ObjectClass oc = this.factory.getObjectClass(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterObjectClass(oldAt.getOid());
        } else {
            this.unregisterOids(oldAt);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(oc);
        } else {
            this.registerOids(oc);
        }
    }

    private void checkNewParent(Dn newParent) throws LdapException {
        if (newParent.size() != 3) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, "The parent dn of a objectClass should be at most 3 name components in length.");
        }
        Rdn rdn = newParent.getRdn();
        if (!this.schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_376, new Object[0]));
        }
        if (!rdn.getNormValue().getString().equalsIgnoreCase("objectClasses")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_377, new Object[0]));
        }
    }
}

