/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.prefs;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.prefs.ServerSystemPreferenceException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.util.PreferencesDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSystemPreferences
extends AbstractPreferences {
    private static final String[] EMPTY_STRINGS = new String[0];
    private List<Modification> changes = new ArrayList<Modification>(3);
    private HashMap<String, List<Modification>> keyToChange = new HashMap(3);
    private Dn dn;
    private DirectoryService directoryService;

    public ServerSystemPreferences(DirectoryService directoryService) {
        super(null, "");
        this.newNode = false;
        try {
            this.dn = directoryService.getDnFactory().create("prefNodeName=sysPrefRoot,ou=system");
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            // empty catch block
        }
        this.directoryService = directoryService;
    }

    public void close() throws LdapException {
    }

    public ServerSystemPreferences(ServerSystemPreferences parent, String name) {
        super(parent, name);
        this.directoryService = parent.directoryService;
        Dn parentDn = ((ServerSystemPreferences)this.parent()).dn;
        try {
            this.dn = this.directoryService.getDnFactory().create("prefNodeName=" + name + "," + parentDn.getName());
            if (!this.directoryService.getAdminSession().exists(this.dn)) {
                Entry entry = this.directoryService.newEntry(this.dn);
                entry.add("objectClass", "top", "prefNode", "extensibleObject");
                entry.add("prefNodeName", name);
                this.directoryService.getAdminSession().add(entry);
                this.newNode = false;
            }
        }
        catch (Exception e) {
            throw new ServerSystemPreferenceException(I18n.err(I18n.ERR_270, new Object[0]), e);
        }
    }

    public Dictionary<String, String> wrapAsDictionary() {
        return new PreferencesDictionary(this);
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        if (this.changes.isEmpty()) {
            return;
        }
        try {
            this.directoryService.getAdminSession().modify(this.dn, this.changes);
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
        this.changes.clear();
        this.keyToChange.clear();
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        try {
            this.directoryService.getAdminSession().delete(this.dn);
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
        this.changes.clear();
        this.keyToChange.clear();
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        if (this.changes.isEmpty()) {
            return;
        }
        try {
            this.directoryService.getAdminSession().modify(this.dn, this.changes);
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
        this.changes.clear();
        this.keyToChange.clear();
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        ArrayList<String> children = new ArrayList<String>();
        try {
            EntryFilteringCursor list = this.directoryService.getAdminSession().list(this.dn, AliasDerefMode.DEREF_ALWAYS, null);
            list.beforeFirst();
            while (list.next()) {
                Entry entry = (Entry)list.get();
                children.add(entry.getDn().getRdn().getNormValue().getString());
            }
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
        return children.toArray(EMPTY_STRINGS);
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        ArrayList<String> keys = new ArrayList<String>();
        try {
            Entry entry = this.directoryService.getAdminSession().lookup(this.dn);
            for (Attribute attr : entry) {
                String oid = attr.getAttributeType().getOid();
                if (oid.equals("2.5.4.0")) continue;
                keys.add(attr.getUpId());
            }
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
        return keys.toArray(EMPTY_STRINGS);
    }

    @Override
    protected void removeSpi(String key) {
        try {
            AttributeType at = this.directoryService.getSchemaManager().lookupAttributeTypeRegistry(key);
            DefaultAttribute attr = new DefaultAttribute(at);
            DefaultModification mi = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, attr);
            this.addDelta(mi);
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    private void addDelta(Modification mi) {
        String key = mi.getAttribute().getUpId();
        this.changes.add(mi);
        List<Modification> deltas = this.keyToChange.containsKey(key) ? this.keyToChange.get(key) : new ArrayList<Modification>();
        deltas.add(mi);
        this.keyToChange.put(key, deltas);
    }

    @Override
    protected String getSpi(String key) {
        try {
            Attribute attr = this.directoryService.getAdminSession().lookup(this.dn).get(key);
            if (this.keyToChange.containsKey(key)) {
                for (Modification mod : this.keyToChange.get(key)) {
                    if (mod.getOperation() == ModificationOperation.REMOVE_ATTRIBUTE) {
                        attr = null;
                        continue;
                    }
                    attr = mod.getAttribute();
                }
            }
            if (attr == null) {
                return null;
            }
            return attr.getString();
        }
        catch (Exception e) {
            throw new ServerSystemPreferenceException(I18n.err(I18n.ERR_271, new Object[0]), e);
        }
    }

    @Override
    protected void putSpi(String key, String value) {
        try {
            AttributeType at = this.directoryService.getSchemaManager().lookupAttributeTypeRegistry(key);
            DefaultAttribute attr = new DefaultAttribute(at, value);
            DefaultModification mi = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attr);
            this.addDelta(mi);
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        return new ServerSystemPreferences(this, name);
    }
}

