/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import org.apache.directory.server.core.avltree.Marshaller;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeRedirect;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeRedirectMarshaller
implements Marshaller<BTreeRedirect> {
    static final int SIZE = 9;
    public static final BTreeRedirectMarshaller INSTANCE = new BTreeRedirectMarshaller();

    @Override
    public final byte[] serialize(BTreeRedirect redirect) throws IOException {
        byte[] bites = new byte[]{1, (byte)(redirect.recId >> 56), (byte)(redirect.recId >> 48), (byte)(redirect.recId >> 40), (byte)(redirect.recId >> 32), (byte)(redirect.recId >> 24), (byte)(redirect.recId >> 16), (byte)(redirect.recId >> 8), (byte)redirect.recId};
        return bites;
    }

    @Override
    public final BTreeRedirect deserialize(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length != 9 || bytes[0] != 1) {
            if (bytes != null) {
                throw new IOException(I18n.err(I18n.ERR_568, Strings.dumpBytes(bytes)));
            }
            throw new IOException(I18n.err(I18n.ERR_569, new Object[0]));
        }
        long recId = bytes[1] + (bytes[1] < 0 ? 256 : 0);
        recId <<= 8;
        recId += (long)(bytes[2] + (bytes[2] < 0 ? 256 : 0));
        recId <<= 8;
        recId += (long)(bytes[3] + (bytes[3] < 0 ? 256 : 0));
        recId <<= 8;
        recId += (long)(bytes[4] + (bytes[4] < 0 ? 256 : 0));
        recId <<= 8;
        recId += (long)(bytes[5] + (bytes[5] < 0 ? 256 : 0));
        recId <<= 8;
        recId += (long)(bytes[6] + (bytes[6] < 0 ? 256 : 0));
        recId <<= 8;
        recId += (long)(bytes[7] + (bytes[7] < 0 ? 256 : 0));
        recId <<= 8;
        return new BTreeRedirect(recId += (long)(bytes[8] + (bytes[8] < 0 ? 256 : 0)));
    }

    public static boolean isRedirect(byte[] bites) {
        return bites != null && bites.length == 9 && bites[0] == 1;
    }
}

